% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ec2-actions.R
\name{ec2_create_security_group}
\alias{ec2_create_security_group}
\title{Create Security Group}
\usage{
ec2_create_security_group(
  GroupDescription,
  GroupName,
  VpcId = NULL,
  TagSpecification = NULL,
  DryRun = NULL,
  simplify = TRUE,
  others = list()
)
}
\arguments{
\item{GroupDescription}{String.   A description for the security group.}

\item{GroupName}{String.   The name of the security group.}

\item{VpcId}{String. [EC2-VPC] The ID of the VPC. Required for EC2-VPC.[optional]}

\item{TagSpecification}{List. The tags to assign to the security group.[optional]}

\item{DryRun}{Logical. Checks whether you have the required permissions for the action, without actually making the request,...[optional]}

\item{simplify}{Logical. Whether to simplify the result and handle \code{nextToken}
in the response[optional]}

\item{others}{Named list. The parameters that are not included in the
function parameters and need to be added into the request[optional]}
}
\value{
A list object or a character vector
}
\description{
Create Security Group
}
\section{GroupDescription}{


A description for the security group. This is informational only.

Constraints: Up to 255 characters in length

Constraints for EC2-Classic: ASCII characters

Constraints for EC2-VPC: a-z, A-Z, 0-9, spaces, and
._-:/()\#,@[]+=&;{}!\$\*
}

\section{GroupName}{


The name of the security group.

Constraints: Up to 255 characters in length. Cannot start with \verb{sg-}.

Constraints for EC2-Classic: ASCII characters

Constraints for EC2-VPC: a-z, A-Z, 0-9, spaces, and
._-:/()\#,@[]+=&;{}!\$\*
}

\section{VpcId}{

[EC2-VPC] The ID of the VPC. Required for
EC2-VPC.
}

\section{TagSpecification}{

The tags to assign to the security
group.
}

\section{DryRun}{

Checks whether you have the required
permissions for the action, without actually making the request, and
provides an error response. If you have the required permissions, the
error response is \code{DryRunOperation}. Otherwise, it is
\code{UnauthorizedOperation}.
}

