% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ec2-actions.R
\name{ec2_associate_subnet_cidr_block}
\alias{ec2_associate_subnet_cidr_block}
\title{Associate Subnet Cidr Block}
\usage{
ec2_associate_subnet_cidr_block(
  SubnetId,
  Ipv6CidrBlock,
  simplify = TRUE,
  others = list()
)
}
\arguments{
\item{SubnetId}{String. The ID of your subnet.}

\item{Ipv6CidrBlock}{String. The IPv6 CIDR block for your subnet. The subnet must have a /64 prefix length.}

\item{simplify}{Logical. Whether to simplify the result and handle \code{nextToken}
in the response[optional]}

\item{others}{Named list. The parameters that are not included in the
function parameters and need to be added into the request[optional]}
}
\value{
A list object or a character vector
}
\description{
Associates a CIDR block with your subnet. You can
only associate a single IPv6 CIDR block with your subnet. An IPv6 CIDR
block must have a prefix length of /64.
}
\section{SubnetId}{

The ID of your
subnet.
}

\section{Ipv6CidrBlock}{

The IPv6 CIDR block for your subnet. The
subnet must have a /64 prefix length.
}

