% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/detect_entities.R
\name{detect_entities}
\alias{detect_entities}
\title{Detect named entities in a source text}
\usage{
detect_entities(text, language = "en", ...)
}
\arguments{
\item{text}{A character string containing a text to entities analyze, or a character vector to perform analysis separately for each element.}

\item{language}{A character string containing a two-letter language code. Currently \dQuote{en} and \dQuote{es} are supported.}

\item{\dots}{Additional arguments passed to \code{\link{comprehendHTTP}}.}
}
\value{
A data frame
}
\description{
Detect entities in a source text
}
\examples{
\dontrun{
  # simple example
  detect_entities("Amazon provides web services. Jeff is their leader.")
  
  txt <-c("Amazon provides web services.",
          "Jeff is their leader.")
  detect_entities(txt)
}
}
