% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/logging.R
\name{start_logging}
\alias{start_logging}
\alias{stop_logging}
\title{logging}
\usage{
start_logging(name, ...)

stop_logging(name, ...)
}
\arguments{
\item{name}{A character string specifying the name of a Cloudtrail or the ARN for a Cloudtrail, or an object of class \dQuote{aws_cloudtrail}.}

\item{\dots}{Additional arguments passed to \code{\link{cloudtrailHTTP}}.}
}
\description{
Start/stop logging
}
\details{
\code{start_logging} starts a
}
\examples{
\dontrun{
  require("aws.s3")
  # create a bucket
  mybucket <- "mybucket_for_cloudtrail"
  stopifnot(put_bucket(mybucket))
  
  # create a trail
  trail <- create_trail("exampletrail", mybucket)
  # confirm trail created
  get_trails()

  # start/stop logging to the trail
  start_logging(trail)
  stop_logging(trail)
  
  # check trail status
  trail_status(trail)
  
  # delete trail
  delete_trail(trail)
}
}
\references{
\url{http://docs.aws.amazon.com/awscloudtrail/latest/APIReference/API_StartLogging.html}, \url{http://docs.aws.amazon.com/awscloudtrail/latest/APIReference/API_StopLogging.html}
}
\seealso{
\code{\link{create_trail}}, \code{\link{trail_status}}
}
