% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_mutant_at_pos.R
\name{get_mutant_at_pos}
\alias{get_mutant_at_pos}
\title{Get single-point mutants of wild-type organisms}
\usage{
get_mutant_at_pos(
  genome_id = NULL,
  inst_replaced = NULL,
  inst_replaced_by = NULL,
  pos = NULL,
  triplestore
)
}
\arguments{
\item{genome_id}{Integer or a list of integer values. If not specified, the
function will return the single-point mutants of a randomly chosen wild-type
organism.}

\item{inst_replaced}{A letter representing the instruction of the genome
sequence of the wild-type organism to be mutated. If not specified,
the function will return the single-point mutants that have replaced the
letter that the genome of the wild-type organism carried at that position
(if the position is specified, otherwise it will return the mutations
located on all positions) by the letter indicated in the argument
inst_replaced_by (if specified, otherwise it will return all the mutants at
that position on the genome of the wild type organism).}

\item{inst_replaced_by}{A letter representing the instruction of the genome
of the single-point mutant that have replaced the instruction of the genome
of the wild-type organism. If not specified, the function will return all
single-point mutants that have replaced the letter indicated in the argument
inst_replaced (if specified, otherwise it will return all the mutants at that
position on the genome of the wild type organism) of the genome of the
wild-type organism at that position (if the position is specified, otherwise
it will return the mutations located on all positions).}

\item{pos}{Integer representing the position of the single-point mutation
along the genome of a digital organism (from 1 to 100 for a genome length of
100 instructions). If not specified, the function will return all
single-point mutants of the genome of the wild-type organism.}

\item{triplestore}{Object of class triplestore_access which manages database
access.}
}
\value{
Data frame: Columns: "genome_id_wild_type", "genome_seq_wild_type",
"genome_id_mutant", genome_seq_mutant", "pos".
}
\description{
Get the genome sequence of a digital organism (i.e., wild-type)
and its single-point mutants.
}
\examples{

# Create triplestore object
avidaDB <- triplestore_access$new()

# Set access options
avidaDB$set_access_options(
  url = "https://graphdb.fortunalab.org",
  user = "public_avida",
  password = "public_avida",
  repository = "avidaDB_test"
)

get_mutant_at_pos(
  genome_id = 582,
  inst_replaced = 'o',
  inst_replaced_by = 'a',
  pos = 1,
  triplestore = avidaDB)

}
