% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/available.R
\name{available}
\alias{available}
\title{See if a name is available}
\usage{
available(name, browse = getOption("available.browse", TRUE), ...)
}
\arguments{
\item{name}{Name of package to search}

\item{browse}{Whether browser should be opened for all web links,
default = TRUE. Default can be changed by setting
\code{available.browse} in \code{.Rprofile}. See \link[base]{Startup}
for more details.}

\item{...}{Additional arguments passed to \code{\link[utils:available.packages]{utils::available.packages()}}.}
}
\description{
Searches performed
\itemize{
\item Valid package name
\item Already taken on CRAN
\item Positive or negative sentiment
\item Urban Dictionary
}
}
\examples{
\dontrun{
# Check if the available package is available
available("available")

# You can disable opening of browser windows with browse = FALSE
available("survival", browse = FALSE)

# Or by setting a global option
options(available.browse = FALSE)
available("survival")

# Test if a name is available in a non-default CRAN repository by setting
# the `repos` argument
available_on_cran("semaforos")

available_on_cran("semaforos", repos = "https://bisaloo.r-universe.dev")
}
}
