% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/validate_raw_dataframe.r
\name{validate_raw_dataframe}
\alias{validate_raw_dataframe}
\title{Validates the dataframe given to the autovar function}
\usage{
validate_raw_dataframe(raw_dataframe)
}
\arguments{
\item{raw_dataframe}{The raw, unimputed data frame.}
}
\value{
A numeric matrix with converted values and names taken from the data frame.
}
\description{
This function returns the given data frame as a numeric matrix, using \code{as.numeric} to convert any columns in the data frame that are not numeric. A \code{stop()} error is thrown if there is not enough data  in the data frame.
}
\examples{
raw_dataframe <- data.frame(id = rep(1, times = 5),
  tijdstip = c(1, 3, 5, 6, 7),
  home = c(1, 0, 0, NA, 1))
autovarCore:::validate_raw_dataframe(raw_dataframe)
}
