% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RcppExports.R
\name{mean_pillars}
\alias{mean_pillars}
\alias{var_pillars}
\alias{median_pillars}
\title{Get the means/medians/variances of pillars of a 3d array}
\usage{
mean_pillars(arr3d)

var_pillars(arr3d)

median_pillars(arr3d)
}
\arguments{
\item{arr3d}{A 3-dimensional array.}
}
\value{
A matrix where element \code{i,j} is equal to \code{mean(arr3d[i, j, ])},
\code{median(arr3d[i, j, ])}, or \code{var(arr3d[i, j, ])}.
}
\description{
For a 3-dimensional array \code{arr3d}, pillar \code{ij} is defined as
\code{arr3d[i, j, ]}. These functions compute the mean, median and variance of each
pillar.
}
\examples{
m3 <- array(1:16, dim = c(2, 2, 4))
mean_pillars(m3)
median_pillars(m3)
var_pillars(m3)

}
