% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_params.R
\name{get_params}
\alias{get_params}
\alias{get_params.xgb.Booster}
\alias{get_params.workflow}
\title{get params}
\usage{
get_params(model, ...)

\method{get_params}{xgb.Booster}(model, ...)

\method{get_params}{workflow}(model, ...)
}
\arguments{
\item{model}{a model}

\item{...}{additional arguments}
}
\value{
list of params
}
\description{
s3 method to extract params of a model with names consistent for use in the `autostats` package
}
\examples{

iris \%>\%
  framecleaner::create_dummies() -> iris_dummies

iris_dummies \%>\%
  tidy_formula(target = Petal.Length) -> p_form

iris_dummies \%>\%
  tidy_xgboost(p_form, mtry = .5, trees = 5L, loss_reduction = 2, sample_size = .7) -> xgb

## reuse these parameters to find the cross validated error

rlang::exec(auto_model_accuracy, data = iris_dummies, formula = p_form, !!!get_params(xgb))
}
