% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/auto_variable_contributions.R
\name{auto_variable_contributions}
\alias{auto_variable_contributions}
\title{Plot Variable Contributions}
\usage{
auto_variable_contributions(data, formula, scale = TRUE)
}
\arguments{
\item{data}{dataframe}

\item{formula}{formula}

\item{scale}{logical. If FALSE puts coefficients on original scale}
}
\value{
a ggplot object
}
\description{
Return a variable importance plot and coefficient plot from a linear model. Used to easily visualize
the contributions of explanatory variables in a supervised model
}
\examples{

iris \%>\%
framecleaner::create_dummies() \%>\%
auto_variable_contributions(
 tidy_formula(., target = Petal.Width)
 )

iris \%>\%
auto_variable_contributions(
tidy_formula(., target = Species)
)
}
