% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tidy_xgboost.R
\name{create_monotone_constraints}
\alias{create_monotone_constraints}
\title{create monotone constraints}
\usage{
create_monotone_constraints(
  .data,
  formula,
  decreasing = NULL,
  increasing = NULL
)
}
\arguments{
\item{.data}{dataframe, training data for tidy_xgboost}

\item{formula}{formula used for tidy_xgboost}

\item{decreasing}{character vector or tidyselect regular expression to designate decreasing cols}

\item{increasing}{character vector or tidyselect regular expression to designate increasing cols}
}
\value{
a named integer vector with entries of 0, 1, -1
}
\description{
helper function to create the integer vector to pass to the \code{monotone_constraints} argument in xgboost
}
\examples{



iris \%>\%
framecleaner::create_dummies(Species) -> iris_dummy

iris_dummy \%>\%
 tidy_formula(target= Petal.Length) -> petal_form

iris_dummy \%>\%
 create_monotone_constraints(petal_form,
                             decreasing = tidyselect::matches("Petal|Species"),
                             increasing = "Sepal.Width")

}
