% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/t_ae_pt_soc_diff_slide.R
\name{t_ae_pt_soc_diff_slide}
\alias{t_ae_pt_soc_diff_slide}
\title{Adverse event table}
\usage{
t_ae_pt_soc_diff_slide(
  adsl,
  adae,
  arm = "TRT01A",
  cutoff = NA,
  split_by_study = FALSE,
  side_by_side = NULL
)
}
\arguments{
\item{adsl}{ADSL data set, dataframe}

\item{adae}{ADAE data set, dataframe}

\item{arm}{Arm variable, character, "`TRT01A" by default.}

\item{cutoff}{Cutoff threshold}

\item{split_by_study}{Split by study, building structured header for tables}

\item{side_by_side}{"GlobalAsia" or "GlobalAsiaChina" to define the side by side requirement}
}
\value{
rtables object
}
\description{
Adverse event table
}
\note{
* Default arm variables are set to `"TRT01A"` for safety output, and
 `"TRT01P"` for efficacy output
}
\examples{
library(dplyr)
adsl <- eg_adsl \%>\%
  dplyr::mutate(TRT01A = factor(TRT01A, levels = c("A: Drug X", "B: Placebo")))
adae <- eg_adae \%>\%
  dplyr::mutate(
    TRT01A = factor(TRT01A, levels = c("A: Drug X", "B: Placebo")),
    ATOXGR = AETOXGR
  )
out <- t_ae_pt_soc_diff_slide(adsl, adae, "TRT01A", 2)
print(out)
generate_slides(out, paste0(tempdir(), "/ae_diff.pptx"))
}
