% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/t_aesi_slide.R
\name{t_aesi_slide}
\alias{t_aesi_slide}
\title{Table of AEs of Special Interest
adapted from https://insightsengineering.github.io/tlg-catalog/stable/tables/adverse-events/aet01_aesi.html}
\usage{
t_aesi_slide(adsl, adae, aesi, arm = "ACTARM", grad_var = "AETOXGR")
}
\arguments{
\item{adsl}{ADSL data set, dataframe}

\item{adae}{ADAE data set, dataframe.}

\item{aesi}{AESI variable which will act as a filter to select the rows required to create the table.
An example of AESI variable is CQ01NAM.}

\item{arm}{Arm variable, character, `"ACTARM"` by default.}

\item{grad_var}{Grading variable, character, `"AETOXGR"` by default.}
}
\value{
rtables object
}
\description{
Table of AEs of Special Interest
adapted from https://insightsengineering.github.io/tlg-catalog/stable/tables/adverse-events/aet01_aesi.html
}
\examples{
library(dplyr)
adsl <- eg_adsl
adae <- eg_adae
adae_atoxgr <- adae \%>\% dplyr::mutate(ATOXGR = AETOXGR)
t_aesi_slide(adsl, adae, aesi = "CQ01NAM")
t_aesi_slide(adsl, adae, aesi = "CQ01NAM", arm = "ARM", grad_var = "AESEV")
t_aesi_slide(adsl, adae_atoxgr, aesi = "CQ01NAM", grad_var = "ATOXGR")

}
\author{
Kai Xiang Lim (`limk43`)
}
