% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/generic_methods.R, R/package.R
\docType{package}
\name{autoplotly}
\alias{autoplotly}
\alias{autoplotly}
\alias{autoplotly-package}
\title{Automatic Visualization of Popular Statistical Results Using 'plotly.js' and 'ggplot2'}
\usage{
autoplotly(object, ..., width = NULL, height = NULL, tooltip = "all",
  dynamicTicks = FALSE, layerData = 1, originalData = TRUE,
  source = "A", widths = NULL, heights = NULL, margin = 0.02,
  shareX = TRUE, shareY = TRUE, titleX = shareX, titleY = shareY,
  which_layout = "merge")
}
\arguments{
\item{object}{The object that represents your statistical result, e.g. \code{stats::prcomp(iris[-5])}.}

\item{...}{Arguments passed to \code{ggfortify::autoplot} function for the applied
object. For example, if your object is constructed from \code{stats::prcomp(iris[-5])},
you can find the documentation for the list of additional arguments via
\code{?ggfortify:::autoplot.prcomp()}.}

\item{width}{Width of the plot in pixels (optional, defaults to automatic sizing).}

\item{height}{Height of the plot in pixels (optional, defaults to automatic sizing).}

\item{tooltip}{a character vector specifying which aesthetic mappings to show
in the tooltip. The default, "all", means show all the aesthetic mappings
(including the unofficial "text" aesthetic). The order of variables here will
also control the order they appear. For example, use
\code{tooltip = c("y", "x", "colour")} if you want y first, x second, and
colour last.}

\item{dynamicTicks}{should plotly.js dynamically generate axis tick labels?
Dynamic ticks are useful for updating ticks in response to zoom/pan
interactions; however, they can not always reproduce labels as they
would appear in the static ggplot2 image.}

\item{layerData}{data from which layer should be returned?}

\item{originalData}{should the "original" or "scaled" data be returned?}

\item{source}{a character string of length 1. Match the value of this string
with the source argument in \code{\link[=event_data]{event_data()}} to retrieve the
event data corresponding to a specific plot (shiny apps can have multiple plots).}

\item{widths}{relative width of each column on a 0-1 scale. By default all
columns have an equal relative width.}

\item{heights}{relative height of each row on a 0-1 scale. By default all
rows have an equal relative height.}

\item{margin}{either a single value or four values (all between 0 and 1).
If four values are provided, the first is used as the left margin, the second
is used as the right margin, the third is used as the top margin, and the
fourth is used as the bottom margin.
If a single value is provided, it will be used as all four margins.}

\item{shareX}{should the x-axis be shared amongst the subplots?}

\item{shareY}{should the y-axis be shared amongst the subplots?}

\item{titleX}{should x-axis titles be retained?}

\item{titleY}{should y-axis titles be retained?}

\item{which_layout}{adopt the layout of which plot? If the default value of
"merge" is used, layout options found later in the sequence of plots will
override options found earlier in the sequence. This argument also accepts a
numeric vector specifying which plots to consider when merging.}
}
\description{
This function provides functionality to automatically generate interactive
plot for many popular statistical results supported by 'ggfortify' package using 'plotly.js' and 'ggplot2'.

This package provides functionalities to automatically generate interactive visualizations for
many popular statistical results supported by ggfortify package with 'plotly.js' and 'ggplot2' style.
The generated plot can also be easily extended using 'ggplot2' and 'plotly' syntax while staying interactive.
}
\examples{
# Automatically generate interactive plot for results produced by `stats::prcomp`
p <- autoplotly(prcomp(iris[c(1, 2, 3, 4)]), data = iris,
                colour = 'Species', label = TRUE, label.size = 3, frame = TRUE)

# You can apply additional ggplot2 elements to interactive plot built using `autoplotly()`
p <- p +
  ggplot2::ggtitle("Principal Components Analysis") +
  ggplot2::labs(y = "Second Principal Components", x = "First Principal Components")
p
}
