% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tree_routines.R
\name{path_to_root}
\alias{path_to_root}
\title{Extract a path from node to root.}
\usage{
path_to_root(th, node_num)
}
\arguments{
\item{th}{A TreeHarp object.}

\item{node_num}{A node number to start tracking upwards from.}
}
\value{
A vector of 1's and 0's that can be used to carve out the branch 
alone, using \code{\link{carve_subtree}}.
}
\description{
Identifies the nodes on the path from a node up to the root of a TreeHarp
object.
}
\details{
This function allows the user to identify the branch from a node 
up to the root of a tree.
}
\examples{
ex1 <- quote(x <- f(y, g(5)))
th1 <- TreeHarp(ex1, TRUE)
path_to_root(th1, 5)
}
