% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tree_routines.R
\name{get_next_subtree}
\alias{get_next_subtree}
\title{Generate the next sub-tree.}
\usage{
get_next_subtree(obj, char_arr)
}
\arguments{
\item{obj}{An object of class TreeHarp.}

\item{char_arr}{A vector of 1's and 0's indicating which nodes to keep. The
vector should have length equal to the number of nodes in obj.}
}
\value{
A vector of 1's and 0's, which denotes the next sub-tree in the list.
}
\description{
This generates the next sub-tree in the enumeration list.
}
\details{
Need to reference the paper. This generates the next sub-tree,
rooted at the root node of this tree. It will generate singletons on it's
own. It has to be used within a loop to do that.
}
\examples{
th1 <- TreeHarp(list(a=c(2,3), b=NULL, c=NULL))
get_next_subtree(th1, c(1,0,0))
get_next_subtree(th1, c(1,1,0))

}
\seealso{
\code{\link{generate_all_subtrees}}
}
