% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot_convergence.R
\name{plot_convergence}
\alias{plot_convergence}
\alias{plot.ag_conv}
\alias{plot.traces.monan}
\alias{plot.mcmc.list}
\title{Plotting convergence diagnostics}
\usage{
\method{plot}{ag_conv}(x, ...)

\method{plot}{traces.monan}(x, ...)

\method{plot}{mcmc.list}(x, ...)
}
\arguments{
\item{x}{An object of class "traces.monan".}

\item{...}{Additional plotting parameters, currently unused.}
}
\value{
The function shows a line plot tracing the statistics obtained at
each simulation step, as well as a density plot showing the distribution
of the statistics over the entire simulation.
}
\description{
These plotting methods are for diagnosing the convergence of
simulation-based estimation procedures, such as those used in
MoNAn and ergm.
These plots are useful for identifying whether the estimation procedure
has adequately explored the state space and converged to a stable
distribution.
}
\examples{
plot(monan_conv)
plot(ergm_res$sample)
}
\seealso{
Other MoNAn: 
\code{\link{plot_gof}}

Other ergm: 
\code{\link{plot_gof}}
}
\concept{MoNAn}
\concept{ergm}
