% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/autoReg.R, R/autoReg.coxph.R
\name{autoReg}
\alias{autoReg}
\alias{autoReg.lm}
\alias{autoReg.glm}
\alias{autoReg.coxph}
\title{Perform univariable and multivariable regression and stepwise backward regression automatically}
\usage{
autoReg(x, ...)

\method{autoReg}{lm}(x, ...)

\method{autoReg}{glm}(x, ...)

\method{autoReg}{coxph}(x, ...)
}
\arguments{
\item{x}{An object of class lm, glm or coxph}

\item{...}{Further arguments}
}
\value{
autoReg returns an object of class "autoReg" which inherits from the class "data.frame"
with at least the following attributes:
\describe{
\item{attr(*,"yvars)}{character. name of dependent variable}
\item{attr(*,"model")}{name of model. One of "lm","glm" or "coxph"}
}
}
\description{
Perform univariable and multivariable regression and stepwise backward regression automatically
}
\section{Methods (by class)}{
\itemize{
\item \code{lm}: S3 method for a class lm

\item \code{glm}: S3 method for a class glm

\item \code{coxph}: S3 method for a class coxph
}}

\examples{
data(cancer,package="survival")
fit=glm(status~rx+sex+age+obstruct+nodes,data=colon,family="binomial")
autoReg(fit)
autoReg(fit,uni=FALSE,final=TRUE)
autoReg(fit,uni=FALSE,imputed=TRUE)
fit=lm(mpg~wt*hp+am+I(wt^2),data=mtcars)
autoReg(fit,final=TRUE)
autoReg(fit,imputed=TRUE)
}
