% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gb_classifier.R
\name{gb_classifier}
\alias{gb_classifier}
\title{GB classifier}
\usage{
gb_classifier(
  form,
  distribution,
  data.train,
  n.trees,
  interaction.depth,
  n.minobsinnode,
  shrinkage,
  verbose = c(TRUE, FALSE)
)
}
\arguments{
\item{form}{Model formula. A two-sided linear formula describing
the model to be fit, with the outcome on the LHS and the covariates
separated by + operators on the RHS.}

\item{distribution}{Model distribution. A character string specifying the
name of the distribution to be used.}

\item{data.train}{Training data. A data.frame containing the training data
used to train the model.}

\item{n.trees}{Total number of trees. An integer-valued scalar specifying
the total number of trees to be fit.}

\item{interaction.depth}{Interaction depth. An integer-valued scalar
specifying the maximum depth of each tree.}

\item{n.minobsinnode}{Minimum number of observations in terminal nodes. An
integer-valued scalar specifying the minimum number of observations in the
terminal nodes of the trees.}

\item{shrinkage}{Learning rate. A numeric scalar specifying the shrinkage or
learning rate applied to each tree in the expansion.}

\item{verbose}{Verbose output. A logical vector indicating whether or not
verbose output should be printed.}
}
\value{
A gradient tree boosting model. A \code{\link[gbm]{gbm}} object.
}
\description{
\code{gb_classifier} applies gradient boosting classification to a data set.
}
