% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/report.augmentedRCBD.R
\name{report.augmentedRCBD}
\alias{report.augmentedRCBD}
\title{Generate MS Word Report from \code{augmentedRCBD} Output}
\usage{
report.augmentedRCBD(aug, target)
}
\arguments{
\item{aug}{An object of class \code{augmentedRCBD}.}

\item{target}{The path to the docx file to be created.}
}
\description{
\code{report.augmentedRCBD} generates a tidy report from an object of
class \code{augmentedRCBD} as docx MS word file using the
\code{\link[officer]{officer}} package.
}
\examples{
# Example data
blk <- c(rep(1,7),rep(2,6),rep(3,7))
trt <- c(1, 2, 3, 4, 7, 11, 12, 1, 2, 3, 4, 5, 9, 1, 2, 3, 4, 8, 6, 10)
y1 <- c(92, 79, 87, 81, 96, 89, 82, 79, 81, 81, 91, 79, 78, 83, 77, 78, 78,
        70, 75, 74)
y2 <- c(258, 224, 238, 278, 347, 300, 289, 260, 220, 237, 227, 281, 311, 250,
        240, 268, 287, 226, 395, 450)
data <- data.frame(blk, trt, y1, y2)
# Convert block and treatment to factors
data$blk <- as.factor(data$blk)
data$trt <- as.factor(data$trt)
# Results for variable y1 (checks inferred)
out <- augmentedRCBD(data$blk, data$trt, data$y1, method.comp = "lsd",
                      alpha = 0.05, group = TRUE, console = FALSE)

\donttest{
report.augmentedRCBD(out, file.path(tempdir(), "augmentedRCBD output.docx"))
}

}
\seealso{
\code{\link[officer]{officer}}, \code{\link[flextable]{flextable}}
}
