% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/score_mae.R
\name{score_mae}
\alias{score_mae}
\alias{scoreMAE}
\title{Mean Absolute Error}
\usage{
score_mae(object, data = NULL, y = NULL, ...)

scoreMAE(object)
}
\arguments{
\item{object}{An object of class \code{explainer} created with function
\code{\link[DALEX]{explain}} from the DALEX package.}

\item{data}{New data that will be used to calculate the score.
Pass \code{NULL} if you want to use \code{data} from \code{object}.}

\item{y}{New y parameter will be used to calculate score.}

\item{...}{Other arguments dependent on the type of score.}
}
\value{
An object of class \code{auditor_score}.
}
\description{
Mean Absolute Error.
}
\examples{
dragons <- DALEX::dragons[1:100, ]

# fit a model
model_lm <- lm(life_length ~ ., data = dragons)

# create an explainer
lm_audit <- audit(model_lm, data = dragons, y = dragons$life_length)

# calculate score
score_mae(lm_audit)


}
\seealso{
\code{\link{score}}
}
