% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot_prc.R, R/plot_roc.R
\name{plot_prc}
\alias{plot_prc}
\alias{plot_roc}
\alias{plotROC}
\title{Precision-Recall Curve (PRC)}
\usage{
plot_prc(object, ..., nlabel = NULL)

plot_roc(object, ..., nlabel = NULL)

plotROC(object, ..., nlabel = NULL)
}
\arguments{
\item{object}{An object of class \code{auditor_model_evaluation} created with \code{\link{model_evaluation}} function.}

\item{...}{Other \code{auditor_model_evaluation} objects to be plotted together.}

\item{nlabel}{Number of cutoff points to show on the plot. Default is \code{NULL}.}
}
\value{
A ggplot object.

A ggplot object.
}
\description{
Precision-Recall Curve summarize the trade-off between the true positive rate and the positive predictive
value for a model. It is useful for measuring performance and comparing classificators.

Receiver Operating Characteristic Curve is a plot of the true positive rate (TPR)
against the false positive rate (FPR) for the different thresholds.
It is useful for measuring and comparing the accuracy of the classificators.
}
\examples{
library(DALEX)

# fit a model
model_glm <- glm(survived ~ ., family = binomial, data = titanic_imputed)

glm_audit <- audit(model_glm,
                   data = titanic_imputed,
                   y = titanic_imputed$survived)

# validate a model with auditor
eva_glm <- model_evaluation(glm_audit)

# plot results
plot_prc(eva_glm)
plot(eva_glm)

#add second model
model_glm_2 <- glm(survived ~ .-age, family = binomial, data = titanic_imputed)
glm_audit_2 <- audit(model_glm_2,
                     data = titanic_imputed,
                     y = titanic_imputed$survived,
                     label = "glm2")
eva_glm_2 <- model_evaluation(glm_audit_2)

plot_prc(eva_glm, eva_glm_2)
plot(eva_glm, eva_glm_2)

data(titanic_imputed, package = "DALEX")

# fit a model
model_glm <- glm(survived ~ ., family = binomial, data = titanic_imputed)

# use DALEX package to wrap up a model into explainer
glm_audit <- audit(model_glm,
                   data = titanic_imputed,
                   y = titanic_imputed$survived)

# validate a model with auditor
eva_glm <- model_evaluation(glm_audit)

# plot results
plot_roc(eva_glm)
plot(eva_glm)

#add second model
model_glm_2 <- glm(survived ~ .-age, family = binomial, data = titanic_imputed)
glm_audit_2 <- audit(model_glm_2,
                     data = titanic_imputed,
                     y = titanic_imputed$survived,
                     label = "glm2")
eva_glm_2 <- model_evaluation(glm_audit_2)

plot_roc(eva_glm, eva_glm_2)
plot(eva_glm, eva_glm_2)

}
\seealso{
\code{\link{plot_rroc}, \link{plot_rec}}
}
