% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/score_peak.R
\name{score_peak}
\alias{score_peak}
\alias{scorePeak}
\title{Peak Score}
\usage{
score_peak(object, variable = NULL, data = NULL, y = NULL, ...)

scorePeak(object)
}
\arguments{
\item{object}{An object of class \code{explainer} created with function
\code{\link[DALEX]{explain}} from the DALEX package.}

\item{variable}{Name of model variable to order residuals.}

\item{data}{New data that will be used to calcuate the score.
Pass \code{NULL} if you want to use \code{data} from \code{object}.}

\item{y}{New y parameter will be used to calculate score.}

\item{...}{Other arguments dependent on the type of score.}
}
\value{
An object of class \code{auditor_score}.
}
\description{
This score is calculated on the basis of Peak test,
 which is used for checking for homoscedasticity of residuals in regression analyses.
}
\examples{
dragons <- DALEX::dragons[1:100, ]

# fit a model
model_lm <- lm(life_length ~ ., data = dragons)

# create an explainer
lm_audit <- audit(model_lm, data = dragons, y = dragons$life_length)

# calculate score
score_peak(lm_audit)

}
