% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot_pca.R
\name{plot_pca}
\alias{plot_pca}
\alias{plotModelPCA}
\title{Principal Component Analysis of models}
\usage{
plot_pca(object, ..., scale = TRUE)

plotModelPCA(object, ..., scale = TRUE)
}
\arguments{
\item{object}{An object of class 'auditor_model_residual' created with \code{\link{model_residual}} function.}

\item{...}{Other 'auditor_model_residual' objects to be plotted together.}

\item{scale}{A logical value indicating whether the models residuals should be scaled before the analysis.}
}
\value{
A ggplot object.
}
\description{
Principal Component Analysis of models residuals.
PCA can be used to assess the similarity of the models.
}
\examples{
dragons <- DALEX::dragons[1:100, ]

# fit a model
model_lm <- lm(life_length ~ ., data = dragons)

# use DALEX package to wrap up a model into explainer
exp_lm <- DALEX::explain(model_lm, data = dragons, y = dragons$life_length)

# validate a model with auditor
library(auditor)
mr_lm <- model_residual(exp_lm)

library(randomForest)
model_rf <- randomForest(life_length~., data = dragons)
exp_rf <- DALEX::explain(model_rf, data = dragons, y = dragons$life_length)
mr_rf <- model_residual(exp_rf)

# plot results
plot_pca(mr_lm, mr_rf)

}
