% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plotD3_lift.R
\name{plotD3_lift}
\alias{plotD3_lift}
\alias{plotD3LIFT}
\title{Plot LIFT in D3 with r2d3 package.}
\usage{
plotD3_lift(object, ..., scale_plot = FALSE)

plotD3LIFT(object, ..., scale_plot = FALSE)
}
\arguments{
\item{object}{An object of class 'auditor_model_evaluation' created with \code{\link{model_evaluation}} function.}

\item{...}{Other 'auditor_model_evaluation' objects to be plotted together.}

\item{scale_plot}{Logical, indicates whenever the plot should scale with height. By default it's FALSE.}
}
\value{
a `r2d3` object
}
\description{
LIFT is a plot of the rate of positive prediction against true positive rate for the different thresholds.
It is useful for measuring and comparing the accuracy of the classificators.
}
\examples{
titanic <- na.omit(DALEX::titanic)
titanic$survived <- titanic$survived == "yes"

# fit a model
model_glm <- glm(survived ~ ., family = binomial, data = titanic)

# use DALEX package to wrap up a model into explainer
exp_glm <- DALEX::explain(model_glm, data = titanic, y = titanic$survived)

# validate a model with auditor
library(auditor)
eva_glm <- model_evaluation(exp_glm)

# plot results
plotD3_lift(eva_glm)

model_glm_2 <- glm(survived ~ .-age, family = binomial, data = titanic)
exp_glm_2 <- DALEX::explain(model_glm_2, data = titanic, y = titanic$survived, label = "glm2")
eva_glm_2 <- model_evaluation(exp_glm_2)

plotD3_lift(eva_glm, eva_glm_2)

}
\seealso{
\code{\link{plot_lift}}
}
