% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/score.R
\name{score}
\alias{score}
\title{Model Scores computations}
\usage{
score(object, score = "mse", ...)
}
\arguments{
\item{object}{An object of class 'explainer' created with function \code{\link[DALEX]{explain}} from the DALEX package.}

\item{score}{The score to  be calculated. Possible values: 'auc' 'cookdistance', 'dw', 'peak', 'halfnormal', 'mae', 'mse', 'rec', 'rmse', 'rroc', 'runs'
(for detailed description see functions in see also section).}

\item{...}{Other arguments dependent on the type of score.}
}
\value{
An object of class 'auditor_score', except Cooks distance, where numeric vector is returned.
}
\description{
This function provides several scores for model validation and performance assessment.
Scores can be also used to compare models.
}
\examples{
dragons <- DALEX::dragons[1:100, ]

# fit a model
model_lm <- lm(life_length ~ ., data = dragons)

# use DALEX package to wrap up a model into explainer
exp_lm <- DALEX::explain(model_lm, data = dragons, y = dragons$life_length)

# calculate score
score(exp_lm, score = 'mae')

}
\seealso{
\code{\link{score_auc}}, \code{\link{score_cooksdistance}, \link{score_dw}, \link{score_peak}, \link{score_halfnormal}, \link{score_mae},
\link{score_mse}, \link{score_rec}, \link{score_rroc}, \link{score_runs}}
}
