% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/modelResiduals.R
\name{modelResiduals}
\alias{modelResiduals}
\title{Create Model Residuals explainer}
\usage{
modelResiduals(object, variable = NULL)
}
\arguments{
\item{object}{An object of class ModelAudit.}

\item{variable}{Optional. Name of variable to order residuals. If value is NULL data order is taken. If value is "Predicted response" or "Fitted values" then data is ordered by fitted values. If value is "Observed response" the data is ordered by a vector of actual response (\code{y} parameter passed to the \code{\link{audit}} function).}
}
\description{
Creates modelResiduals object to be plotted.
}
\examples{
library(MASS)
model.glm <- glm(Postwt ~ Prewt + Treat + offset(Prewt), family = gaussian, data = anorexia)
audit.glm <- audit(model.glm)

mr.glm <- modelResiduals(audit.glm)

}
