# WARNING - Generated by {fusen} from dev/flat_create_dependencies_file.Rmd: do not edit by hand

# Copy package in a temporary directory
tmpdir <- tempfile(pattern = "pkgdeps")
dir.create(tmpdir)
file.copy(system.file("dummypackage",package = "attachment"), tmpdir, recursive = TRUE)
dummypackage <- file.path(tmpdir, "dummypackage")
# browseURL(dummypackage)

# Create the dependencies commands but no file
test_that("create_dependencies_file does not create file with NULL", {
  
  out_list <- create_dependencies_file(
    path = file.path(dummypackage, "DESCRIPTION"),
    to = NULL,
    field = c("Depends", "Imports", "Suggests"),
    open_file = FALSE)
  
  expect_false(file.exists(
    file.path(dummypackage, "inst", "dependencies.R")))
})

create_dependencies_file(
  path = file.path(dummypackage, "DESCRIPTION"),
  to = file.path(dummypackage, "inst", "dependencies.R"),
  field = c("Depends", "Imports", "Suggests"),
  open_file = FALSE)

  expect_true(file.exists(
    file.path(dummypackage, "inst", "dependencies.R")))
  
dep_file_without_remotes <- readLines(file.path(dummypackage, "inst", "dependencies.R"))

test_that("create-dependencies-file works without remotes", {
  expect_equal(dep_file_without_remotes[1], "# No Remotes ----")
  expect_equal(dep_file_without_remotes[3], "to_install <- c(\"knitr\", \"magrittr\", \"rmarkdown\", \"testthat\")")
})
  

  # Add remotes in DESCRIPTION

  # Test internal_remotes_to_desc ----
  tmpdir <- tempfile(pattern = "pkgwithremotes")
  dir.create(tmpdir)
  file.copy(system.file("dummypackage",package = "attachment"), tmpdir, recursive = TRUE)
  dummypackage <- file.path(tmpdir, "dummypackage")

  path.d <- file.path(dummypackage, "DESCRIPTION")

  cat(c("Remotes:\n     ThinkR-open/attachment,\n     local::/path/fakelocal,\n     gitlab::statnmap/fakepkg,\n     bioc::3.3/fakepkgbioc,\n     git::https://github.com/fakepkggit.git,\n     git::https://MyForge.com/fakepkggit2r,\n     ThinkR-open/fusen\n"), append = TRUE,
      file = path.d)

  new_desc <- readLines(path.d)

create_dependencies_file(path = file.path(dummypackage,"DESCRIPTION"),
                         to = file.path(dummypackage, "inst/dependencies.R"),
                         field = c("Depends", "Imports", "Suggests"),
                         open_file = FALSE)

dep_file_with_remotes <- readLines(file.path(tmpdir, "dummypackage", "inst/dependencies.R"))

test_that("create-dependencies-file works with remotes", {
  expect_equal(dep_file_with_remotes[1], "# Remotes ----")
  expect_equal(dep_file_with_remotes[3], "remotes::install_github('ThinkR-open/attachment')")
  expect_equal(dep_file_with_remotes[4], "remotes::install_local('path/fakelocal')")
  expect_equal(dep_file_with_remotes[5], "remotes::install_gitlab('statnmap/fakepkg')")
  expect_equal(dep_file_with_remotes[6], "remotes::install_bioc('3.3/fakepkgbioc')")
  expect_equal(dep_file_with_remotes[7], "remotes::install_git('https://github.com/fakepkggit.git')")
  expect_equal(dep_file_with_remotes[8], "remotes::install_git('https://MyForge.com/fakepkggit2r')")
  expect_equal(dep_file_with_remotes[9], "remotes::install_github('ThinkR-open/fusen')")
  expect_equal(dep_file_with_remotes[11], "to_install <- c(\"knitr\", \"magrittr\", \"rmarkdown\", \"testthat\")")
})


create_dependencies_file(path = file.path(dummypackage,"DESCRIPTION"),
                         to = file.path(dummypackage, "inst/dependencies.R"),
                         field = c("Depends", "Imports", "Suggests"),
                         open_file = FALSE,
                         install_only_if_missing = TRUE)

dep_file_with_remotes_install_only_if_missing <- readLines(file.path(tmpdir, "dummypackage", "inst/dependencies.R"))

test_that("create-dependencies-file works with remotes install_only_if_missing", {
  expect_equal(dep_file_with_remotes_install_only_if_missing[1], "# Remotes ----")
  expect_equal(dep_file_with_remotes_install_only_if_missing[3], "if(isFALSE(requireNamespace('attachment', quietly = TRUE))) {message('installation of attachment');remotes::install_github('ThinkR-open/attachment')}")
  expect_equal(dep_file_with_remotes_install_only_if_missing[4], "if(isFALSE(requireNamespace('fakelocal', quietly = TRUE))) {message('installation of fakelocal');remotes::install_local('path/fakelocal')}")
  expect_equal(dep_file_with_remotes_install_only_if_missing[5], "if(isFALSE(requireNamespace('fakepkg', quietly = TRUE))) {message('installation of fakepkg');remotes::install_gitlab('statnmap/fakepkg')}")
  expect_equal(dep_file_with_remotes_install_only_if_missing[6], "if(isFALSE(requireNamespace('fakepkgbioc', quietly = TRUE))) {message('installation of fakepkgbioc');remotes::install_bioc('3.3/fakepkgbioc')}")
  expect_equal(dep_file_with_remotes_install_only_if_missing[7], "if(isFALSE(requireNamespace('fakepkggit', quietly = TRUE))) {message('installation of fakepkggit');remotes::install_git('https://github.com/fakepkggit.git')}")
  expect_equal(dep_file_with_remotes_install_only_if_missing[8],  "if(isFALSE(requireNamespace('fakepkggit2r', quietly = TRUE))) {message('installation of fakepkggit2r');remotes::install_git('https://MyForge.com/fakepkggit2r')}")
  expect_equal(dep_file_with_remotes_install_only_if_missing[9], "if(isFALSE(requireNamespace('fusen', quietly = TRUE))) {message('installation of fusen');remotes::install_github('ThinkR-open/fusen')}")
  expect_equal(dep_file_with_remotes_install_only_if_missing[11], "to_install <- c(\"knitr\", \"magrittr\", \"rmarkdown\", \"testthat\")")
})

# Clean temp files after this example
unlink(tmpdir, recursive = TRUE)

