% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/combine-ages.R
\name{combine_ages}
\alias{combine_ages}
\title{Combine ageclasses to juvenile and adult stanza according to age at maturity.}
\usage{
combine_ages(data, grp_col, agemat, value_col = "atoutput")
}
\arguments{
\item{data}{Dataframe with ageclass specific information.}

\item{grp_col}{Character string giving the name of the group column in \code{data}.
E.g. 'species', 'pred', 'prey' etc.}

\item{agemat}{First mature age class for age structured groups. This dataframe should
be generated with \code{\link{prm_to_df}} using "age_mat" as parameter.}

\item{value_col}{Character string giving the name of the column to sum.
Default is \code{"atoutput"}.}
}
\value{
Dataframe with ageclasses combined to stanzas.
}
\description{
Combine ageclasses to juvenile and adult stanza according to age at maturity.
}
\examples{
d <- system.file("extdata", "setas-model-new-trunk", package = "atlantistools")
prm_biol <- file.path(d, "VMPA_setas_biol_fishing_Trunk.prm")
fgs <- file.path(d, "SETasGroupsDem_NoCep.csv")

agemat <- prm_to_df(prm_biol = prm_biol, fgs = fgs,
                    group = get_age_acronyms(fgs = fgs),
                    parameter = "age_mat")

combine_ages(ref_nums, grp_col = "species", agemat = agemat)
}
