% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/is_syntactically_valid_name.R
\name{is_syntactically_valid_name}
\alias{is_syntactically_valid_name}
\title{Checks if valid name}
\usage{
is_syntactically_valid_name(x)
}
\arguments{
\item{x}{An object.}
}
\value{
A logical with length 1. \code{TRUE} when \code{x} is a character with length > 0 without duplicates
and is valid. Else \code{FALSE} and a warning what's wrong.
}
\description{
Checks for valid names by \code{\link[base]{make.names}},
i.e. \code{x} is valid iff \code{make.names} does nothing with \code{x}.
}
\examples{
x <- c('asdf', NA,'.na', '<y', 'asdf', 'asdf.1')
is_syntactically_valid_name(x)
is_syntactically_valid_name(x[FALSE]) # FALSE because empty
is_syntactically_valid_name(NA) # FALSE because not character
is_syntactically_valid_name(as.character(NA)) # FALSE because NA
is_syntactically_valid_name('NA') # FALSE. make.names changes 'NA' to 'NA.'
is_syntactically_valid_name(letters) # TRUE
}
