% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/makeconstobj.R
\name{makeconstobj}
\alias{makeconstobj}
\title{User-guided Function to Create a Constraints Input for ATA Form Creation}
\usage{
makeconstobj( ipool,
 id,
 empty = FALSE)
}
\arguments{
\item{ipool}{Item by characteristic (or property) metadata.}

\item{id}{Name (not actual codes) of unique item identifier (variable).}

\item{empty}{Should the function return an empty list to be filled in manually. Default is \code{FALSE}.}
}
\value{
A list object with "nC" 
                           "nameC" 
                           "lowerC" 
                           "upperC" 
                           "wC"
                           "nI"
                           "set_id"
}
\description{
Guides the user to create a complex list object identifying the constraints to be applied in automated test assembly functions from the \code{ata} package.
}
\examples{
\donttest{
# Step-by-step Parshall et al. (2002) constraint example 
constraints <- makeconstobj( ipool = metadata_example,
                id = "Item",
                empty = FALSE)
                
# User interaction in R console:
# Based on the ID name you submitted, 'Item', there are 10 items in the submitted data. 
#   Is the number of independent items correct? yes/no yes
# ATA form will be created based on the constraints you define.
#   How many constraints do you have? 4
# Constraints will be selected from the data set provided.
#   Do you want to see all unique column names from the submitted data? yes/no yes
#     [1] "Item" "Content" "Content_A" "Content_B" "p" "rpbis" "Parent0" "iSx" "Time" "Parent1"  
# Among the variables in the submitted data, please specify the names of the 4 variables to be 
# used as ATA constraints.
#   Constraint name 1 : Content_A 
#   Constraint name 2 : Content_B 
#   Constraint name 3 : p 
#   Constraint name 4 : iSx
# What are the lower bound values for the constraints?
#   Lower bound value for constraint Content_A : 2
#   Lower bound value for constraint Content_B : 3
#   Lower bound value for constraint p : 3.00
#   Lower bound value for constraint iSx : 0.50
# What are the upper bound values for the constraints?
#   Upper bound value for constraint Content_A : 2
#   Upper bound value for constraint Content_B : 3
#   Upper bound value for constraint p : 3.50
#   Upper bound value for constraint iSx : 0.60
# What are the weights for the constraints?
#   Weight for constraint Content_A : 1
#   Weight for constraint Content_B : 1
#   Weight for constraint p : 1
#   Weight for constraint iSx : 1
# Please specify the ATA form length.
#   What is the total number of items to be selected? 5
# Please specify whether there are items sets in the data.
#   Would you like to aggregate the data based on an ID defined unit? yes/no yes
#     What is the set ID column name to be used for aggregation? Parent0
# Complex list object identifying the constraints to be applied in the ATA was created.
#   $nC
#   [1] 4
#   
#   $nameC
#   [1] "Content_A" "Content_B" "p" "iSx"      
#   
#   $lowerC
#   [1] 2.0 3.0 3.0 0.5
#   
#   $upperC
#   [1] 2.0 3.0 3.5 0.6
#   
#   $wC
#   [1] 1 1 1 1
#   
#   $nI
#   [1] 5
#   
#   $set_id
#   [1] "Parent0"
}  
  
}
\references{
Parhshall, C. G., et al. (2002). Automated test assembly for online administration. In C. G. Parhsall, J. A. Spray, J. C. Kalohn, & T. Davey, Practical considerations in computer based testing (pp.106-125). New York, NY: Springer-Verlag New York, Inc.
}
\author{
Gulsah Gurkan (gurkangulsah@gmail.com), Michael Chajewski (mchajewski@hotmail.com)
}
\keyword{ata}
\keyword{automatest_test_assembly}
\keyword{lp}
\keyword{test_form}
\keyword{test_via_lp}
\keyword{test_via_wdm}
\keyword{testform}
\keyword{wdm}
