% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/f_distrib.R
\name{f_distrib}
\alias{f_distrib}
\title{Distribution}
\usage{
f_distrib(type_function, compile_qt, starting_values)
}
\arguments{
\item{type_function}{String argument : "gaussian" for normal distribution or "skew-t" for t-student distribution}

\item{compile_qt}{Numeric matrix containing different quantiles and associated values}

\item{starting_values}{Numeric vector with initial values for optimization}
}
\value{
a data.frame with the parameters of the distribution
}
\description{
This function is used to estimate the parameters of the distribution (mean and standard deviation for Gaussian, xi, omega, alpha, and nu for skew-t) based on the quantile regression results (Koenker and Basset, 1978). See Adrian et al. (2019) and Adrian et al. (2022) for more details on the estimation steps.
}
\examples{
# Import data
data("data_euro")

# Data process
PIB_euro_forward_4 = data_euro["GDP"][c(5:length(data_euro["GDP"][,1])),]
FCI_euro_lag_4 = data_euro["FCI"][c(1:(length(data_euro["GDP"][,1]) - 4)),]
CISS_euro_lag_4 = data_euro["CISS"][c(1:(length(data_euro["GDP"][,1]) - 4)),]

# for a gaussian
quantile_target <- as.vector(c(0.25,0.75))
results_quantile_reg <- f_compile_quantile(qt_trgt=quantile_target,
v_dep=PIB_euro_forward_4,
v_expl=cbind(FCI_euro_lag_4, CISS_euro_lag_4),
t_trgt = 30)

results_g <- f_distrib(type_function="gaussian",
compile_qt=results_quantile_reg,
starting_values=c(0, 1))

# for a skew-t
quantile_target <- as.vector(c(0.10,0.25,0.75,0.90))
results_quantile_reg <- f_compile_quantile(qt_trgt=quantile_target,
v_dep=PIB_euro_forward_4,
v_expl=cbind(FCI_euro_lag_4, CISS_euro_lag_4),
t_trgt = 30)

results_s <- f_distrib(type_function="skew-t",
compile_qt=results_quantile_reg,
starting_values=c(0, 1, -0.5, 1.3))

}
\references{
Adrian, Tobias, Nina Boyarchenko, and Domenico Giannone. "Vulnerable growth." American Economic Review 109.4 (2019): 1263-89.

Adrian, Tobias, et al. "The term structure of growth-at-risk. " American Economic Journal: Macroeconomics 14.3 (2022): 283-323.

Koenker, Roger, and Gilbert Bassett Jr. "Regression quantiles." Econometrica: journal of the Econometric Society (1978): 33-50.
}
