% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/selection.R
\name{select_covariates}
\alias{select_covariates}
\title{Select covariates}
\usage{
select_covariates(
  model,
  threshold = 0.15,
  direction = c("both", "backward", "forward"),
  addable_coefs = names(get_fixef(model)),
  measure_fn = function(x) summary(x)[["coefficients"]][, 4],
  measure_one_at_time = FALSE,
  minimize_only = FALSE,
  max_steps = 1000,
  return_step_results = FALSE,
  do_not_remove = c("(Intercept)"),
  ...
)
}
\arguments{
\item{model}{A model with \code{\link[stats:update]{stats::update()}}, \code{\link[stats:coef]{stats::coef()}} methods.}

\item{threshold}{Value threshold to remove variable. It can be a fixed value
or a function. The variable is removed if \code{measure_fn(model) > threshold} and
added if \code{measure_fn(model) <= threshold}.}

\item{direction}{The direction of variable selection. Options include "backward",
"forward", or "both". Defaults to "both".}

\item{addable_coefs}{A vector of coefficients that can be added during forward selection.
Defaults to all coefficients in the model.}

\item{measure_fn}{Function with model as argument and returns values to be used by
\code{threshold}. It can also compare two models, where during forward step
it calls \code{measure_fn(candidate_model, current_selected_model)} and
during backward step it calls \code{measure_fn(current_selected_model, candidate_model)}.
Defaults to the p-value from the summary of the coefficients.}

\item{measure_one_at_time}{Boolean indicating to apply \code{measure_fn} to each
variable individually during forward and backward steps.
Set this option to \code{TRUE} if \code{measure_fn} returns an atomic value, for example if
\code{measure_fn} is \code{AIC}.}

\item{minimize_only}{Logical indicating that during backward model update
it should minimize the \code{measure_fn} instead of maximize it.}

\item{max_steps}{The maximum number of steps for the variable selection process.
Defaults to 1000.}

\item{return_step_results}{Logical. If TRUE, the function returns a list
containing the final fitted model and a log of the selection steps.
Defaults to FALSE.}

\item{do_not_remove}{A character vector specifying variables that should not
be removed during backward selection. Defaults to "(Intercept)".}

\item{...}{Extra arguments to \code{\link[stats:update]{stats::update()}}.}
}
\value{
A fitted model with selected covariates based on the variable selection process.
If \code{return_step_results} is TRUE, a list containing the final fitted model
and a log of the selection steps is returned.
}
\description{
Select covariates
}
\examples{
model <- lm(mpg ~ ., data = mtcars)
select_covariates(model)

## measure_fn with two parameters

lrt <- function(model1, model2) {
  lrt_stat <- 2 * (logLik(model1)[1L] - logLik(model2)[1L])
  return(1 - pchisq(lrt_stat, 1))
}

select_covariates(model, measure_fn = lrt)

## AICc selection

AICc <- function(model) {
  loglike <- logLik(model)
  df <- attr(loglike, "df")
  nobs <- attr(loglike, "nobs")
  aic <- -2 * as.numeric(loglike) + 2 * df

  aicc <- aic + (2 * (df^2) + 2 * df) / (nobs - df - 1)

  return(aicc)
}

selection <- select_covariates(model,
  measure_fn = AICc,
  threshold = AICc,
  measure_one_at_time = TRUE,
  minimize_only = TRUE,
  direction = "both",
  data = mtcars
)

}
