% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rule.R
\name{ast_rule}
\alias{ast_rule}
\title{Build a rule}
\usage{
ast_rule(
  pattern = NULL,
  kind = NULL,
  regex = NULL,
  inside = NULL,
  has = NULL,
  precedes = NULL,
  follows = NULL,
  all = NULL,
  any = NULL,
  not = NULL,
  matches = NULL,
  id = NULL
)
}
\arguments{
\item{pattern}{The pattern to look for. This can be a string or an object of
class \code{"astgrep_pattern_rule"} created by \code{pattern_rule()}. This can
contain meta-variables to capture certain elements. Those meta-variables
can then be recovered with \code{\link[=node_get_match]{node_get_match()}} and
\code{\link[=node_get_multiple_matches]{node_get_multiple_matches()}}. The meta-variables must start with \code{$} and
have only uppercase letters, e.g. \verb{$VAR}.}

\item{kind}{The kind of nodes to look for.}

\item{regex}{A regex used to look for nodes. This must follow the syntax of
the Rust \href{https://docs.rs/regex/latest/regex/}{\code{regex} crate}.}

\item{inside}{In which node should the node we look for be positioned? This
can be another rule made with \code{ast_rule()} or an object of class
\code{"astgrep_relational_rule"} created with \code{relational_rule()}.}

\item{has}{Same input type as \code{inside}, but this looks for nodes that contain
another type of node.}

\item{precedes}{Same input type as \code{inside}, but this looks for nodes that
precede another type of node.}

\item{follows}{Same input type as \code{inside}, but this looks for node that
follow another type of node.}

\item{all}{This takes one or a list of rules made with \code{ast_rule()}. It only
matches nodes that respect all of the rules.}

\item{any}{This takes one or a list of rules made with \code{ast_rule()}. It
matches nodes that respect any of the rules.}

\item{not}{This takes one or a list of rules made with \code{ast_rule()}. It
excludes those nodes from the selection.}

\item{matches}{This takes the \code{id} of another rule. It is useful to reuse
rules.}

\item{id}{The name of this rule. This can be reused in another rule with
\code{matches}.}
}
\value{
A list (possibly nested) with the class \code{"astgrep_rule"}.
}
\description{
Rules are the core of \code{astgrepr}. Those are used to search for nodes and are
used in \verb{node_match*()} and \verb{node_find*()} functions. \code{ast_rule()} is a very
flexible function that allows one to build simple rules but also much more
complex and specific ones.
}
\section{About meta-variables}{

Meta-variables allow us to capture some of the content in a pattern. Usually,
using \code{$} followed by an id in uppercase letters is enough:

\if{html}{\out{<div class="sourceCode r">}}\preformatted{src <- "any(duplicated(x))"

root <- src |>
  tree_new() |>
  tree_root()

root |>
  node_find(ast_rule(pattern = "any(duplicated($A))"))
#> <List of 1 rule>
#> |--rule_1: 1 node
}\if{html}{\out{</div>}}

However, in some cases using \code{$} is a problem. For instance, if we want to
capture a column name coming after \code{$}, then we can't use \code{$} both as code
and as identifier.

\if{html}{\out{<div class="sourceCode r">}}\preformatted{src <- "df$a"

root <- src |>
  tree_new() |>
  tree_root()

root |>
  node_find(ast_rule(pattern = "df$$A"))
#> <List of 1 rule>
#> |--rule_1: 0 node
}\if{html}{\out{</div>}}

In this situation, we can use \code{µ} instead:

\if{html}{\out{<div class="sourceCode r">}}\preformatted{root |>
  node_find(ast_rule(pattern = "df$µA"))
#> <List of 1 rule>
#> |--rule_1: 1 node
}\if{html}{\out{</div>}}
}

\examples{
ast_rule(pattern = "print($A)")

ast_rule(
  pattern = "print($A)",
  inside = ast_rule(
    any = ast_rule(
      kind = c("for_statement", "while_statement")
    )
  )
)
}
