% Generated by roxygen2 (4.1.0): do not edit by hand
% Please edit documentation in R/utils.R
\name{n_elements}
\alias{n_elements}
\title{Get the number of elements}
\usage{
n_elements(x)
}
\arguments{
\item{x}{Any object.}
}
\value{
A non-negative integer of the number of elements.
}
\description{
Gets the number of elements in an object.
}
\note{
For atomic objects, the number of elements is the product of the
dimensions, as calculated by \code{\link{DIM}}.  For recursive objects,
the number of elements is the sum of the number of elements of each of
their atomic components.
}
\examples{
n_elements(1:10)
n_elements(NULL)
n_elements(data.frame(x = 1:5, y = rnorm(5)))
n_elements(list(1:5, list(1:3, list(1:7))))
n_elements(var) # depends upon the length of the body
}
\seealso{
\code{\link{DIM}}
}

