% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/assert-is-a-type.R, R/assert-is-type-base.R, R/is-a-type.R, R/is-type-base.R
\name{assert_is_a_double}
\alias{assert_is_a_double}
\alias{assert_is_a_number}
\alias{assert_is_double}
\alias{assert_is_numeric}
\alias{is_a_double}
\alias{is_a_number}
\alias{is_double}
\alias{is_numeric}
\title{Is the input numeric?}
\usage{
assert_is_a_double(x, severity = getOption("assertive.severity", "stop"))

assert_is_a_number(x, severity = getOption("assertive.severity", "stop"))

assert_is_double(x, severity = getOption("assertive.severity", "stop"))

assert_is_numeric(x, severity = getOption("assertive.severity", "stop"))

is_a_double(x, .xname = get_name_in_parent(x))

is_a_number(x, .xname = get_name_in_parent(x))

is_double(x, .xname = get_name_in_parent(x))

is_numeric(x, .xname = get_name_in_parent(x))
}
\arguments{
\item{x}{Input to check.}

\item{severity}{How severe should the consequences of the assertion be?
Either \code{"stop"}, \code{"warning"}, \code{"message"}, or \code{"none"}.}

\item{.xname}{Not intended to be used directly.}
}
\value{
\code{is_numeric} wraps \code{is.numeric}, providing more 
information on failure. \code{is_a_number} returns \code{TRUE} if the 
input is numeric and scalar.  The \code{assert_*} functions return nothing
but throw an error if the corresponding \code{is_*} function returns 
\code{FALSE}.
}
\description{
Checks to see if the input is numeric.
}
\note{
\code{numeric} means either double or integer, inc this case.
}
\examples{
# "numeric" fns work on double or integers; 
assert_is_numeric(1:10)

# Here we check for length 1 as well as type
assert_is_a_number(pi)
assert_is_a_number(1L)
assert_is_a_number(NA_real_)

# "double" fns fail for integers.
assert_is_a_double(pi)

#These examples should fail.
assertive.base::dont_stop(assert_is_numeric(c(TRUE, FALSE)))
assertive.base::dont_stop(assert_is_a_number(1:10))
assertive.base::dont_stop(assert_is_a_number(numeric()))
assertive.base::dont_stop(assert_is_double(1:10))
}
\seealso{
\code{\link{is_integer}}, \code{\link[base]{is.numeric}} and 
\code{\link{is_scalar}}.
}

