% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/assert-is-type-base.R
\name{assert_is_all_of}
\alias{assert_is_all_of}
\alias{assert_is_any_of}
\title{Does x belong to these classes?}
\usage{
assert_is_all_of(x, classes, severity = getOption("assertive.severity",
  "stop"))

assert_is_any_of(x, classes, severity = getOption("assertive.severity",
  "stop"))
}
\arguments{
\item{x}{Input to check.}

\item{classes}{As for \code{class}.}

\item{severity}{How severe should the consequences of the assertion be?
Either \code{"stop"}, \code{"warning"}, \code{"message"}, or \code{"none"}.}
}
\value{
The functions return nothing but throw an error if
\code{x} does not have any/all of the class \code{classes}.
}
\description{
Checks to see if x belongs to any of the classes in classes.
}
\examples{
assert_is_all_of(1:10, c("integer", "numeric"))
#These examples should fail.
assertive.base::dont_stop(assert_is_any_of(1:10, c("list", "data.frame")))
}
\seealso{
\code{\link[assertive.base]{is2}}
}

