% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/assert-is-a-type.R, R/assert-is-type-base.R, R/is-a-type.R, R/is-type-base.R
\name{assert_is_a_string}
\alias{assert_is_a_string}
\alias{assert_is_character}
\alias{is_a_string}
\alias{is_character}
\title{Is the input of type character?}
\usage{
assert_is_a_string(x, severity = getOption("assertive.severity", "stop"))

assert_is_character(x, severity = getOption("assertive.severity", "stop"))

is_a_string(x, .xname = get_name_in_parent(x))

is_character(x, .xname = get_name_in_parent(x))
}
\arguments{
\item{x}{Input to check.}

\item{severity}{How severe should the consequences of the assertion be?
Either \code{"stop"}, \code{"warning"}, \code{"message"}, or \code{"none"}.}

\item{.xname}{Not intended to be used directly.}
}
\value{
\code{is_character} wraps \code{is.character}, providing more
information on failure. \code{is_a_string} returns \code{TRUE} if the
input is character and scalar. \code{is_an_empty_string} returns \code{TRUE}
if the input is \code{""}.  \code{is_numeric_string} is vectorised,
returning \code{TRUE} when the inputs are not \code{NA} after conversion
to character and then numeric. \code{is_missing_or_empty_string} is
also vectorised, returning \code{TRUE} when the input is \code{""} or
\code{NA}.
The \code{assert_*} functions return nothing but throw an error if the
corresponding \code{is_*} function returns \code{FALSE}.
}
\description{
Checks to see if the input is of type character.
}
\examples{
assert_is_character(letters)
assertive.base::dont_stop(assert_is_character(factor(letters)))
}
\seealso{
\code{\link[base]{is.character}} and \code{\link{is_scalar}}.
}

