% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/assert-is-matching-fixed.R, R/is-matching-fixed.R
\name{assert_all_are_matching_fixed}
\alias{assert_all_are_matching_fixed}
\alias{assert_all_are_matching_regex}
\alias{assert_all_are_not_matching_fixed}
\alias{assert_all_are_not_matching_regex}
\alias{assert_any_are_matching_fixed}
\alias{assert_any_are_matching_regex}
\alias{assert_any_are_not_matching_fixed}
\alias{assert_any_are_not_matching_regex}
\alias{is_matching_fixed}
\alias{is_matching_regex}
\alias{is_not_matching_fixed}
\alias{is_not_matching_regex}
\title{Does the string match a pattern?}
\usage{
assert_all_are_matching_fixed(x, pattern, opts_fixed = NULL,
  na_ignore = FALSE, severity = getOption("assertive.severity", "stop"))

assert_any_are_matching_fixed(x, pattern, opts_fixed = NULL,
  na_ignore = FALSE, severity = getOption("assertive.severity", "stop"))

assert_all_are_not_matching_fixed(x, pattern, opts_fixed = NULL,
  na_ignore = FALSE, severity = getOption("assertive.severity", "stop"))

assert_any_are_not_matching_fixed(x, pattern, opts_fixed = NULL,
  na_ignore = FALSE, severity = getOption("assertive.severity", "stop"))

assert_all_are_matching_regex(x, pattern, opts_regex = NULL,
  na_ignore = FALSE, severity = getOption("assertive.severity", "stop"))

assert_any_are_matching_regex(x, pattern, opts_regex = NULL,
  na_ignore = FALSE, severity = getOption("assertive.severity", "stop"))

assert_all_are_not_matching_regex(x, pattern, opts_regex = NULL,
  na_ignore = FALSE, severity = getOption("assertive.severity", "stop"))

assert_any_are_not_matching_regex(x, pattern, opts_regex = NULL,
  na_ignore = FALSE, severity = getOption("assertive.severity", "stop"))

is_matching_fixed(x, pattern, opts_fixed = NULL,
  .xname = get_name_in_parent(x))

is_not_matching_fixed(x, pattern, opts_fixed = NULL,
  .xname = get_name_in_parent(x))

is_matching_regex(x, pattern, opts_regex = NULL,
  .xname = get_name_in_parent(x))

is_not_matching_regex(x, pattern, opts_regex = NULL,
  .xname = get_name_in_parent(x))
}
\arguments{
\item{x}{string}

\item{pattern}{pattern}

\item{opts_fixed}{Passed to \code{\link[stringi]{stri_detect_fixed}}.}

\item{na_ignore}{should NAs be ignored or not?}

\item{severity}{How severe should the consequences of the assertion be?
Either \code{"stop"}, \code{"warning"}, \code{"message"}, or \code{"none"}.}

\item{opts_regex}{Passed to \code{\link[stringi]{stri_detect_regex}}.}

\item{.xname}{Not intended to be used directly.}
}
\description{
Checks to see if in the input matches a regular expression or fixed character
pattern.
}
\examples{
# Is it safe to eat oysters?
is_matching_fixed(month.name, "r")

# Sometimes it is easier to specify the negative match.
is_matching_regex(LETTERS, "[^AEIOU]")
is_not_matching_regex(LETTERS, "[AEIOU]")

# Matching is vectorized over both x and pattern
(pi_digits <- strsplit(format(pi, digits = 17), "")[[1]])
is_matching_regex(pi_digits, c("[13]", "[59]"))

assert_any_are_matching_regex(pi_digits, c("[13]", "[59]"))

# These checks should fail
assertive.base::dont_stop({
  assert_all_are_matching_regex(pi_digits, c("[13]", "[59]"))
})
}
\author{
Aditya Bhagwat
}
\seealso{
\code{\link[stringi]{stri_detect}}, on which these functions are 
based.
}

