% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/assert-is-empty-character.R, R/assert-is-empty-string.R, R/is-empty-character.R, R/is-empty-string.R
\name{assert_all_are_empty_character}
\alias{assert_all_are_empty_character}
\alias{assert_all_are_missing_or_empty_character}
\alias{assert_all_are_non_empty_character}
\alias{assert_all_are_non_missing_nor_empty_character}
\alias{assert_any_are_empty_character}
\alias{assert_any_are_missing_or_empty_character}
\alias{assert_any_are_non_empty_character}
\alias{assert_any_are_non_missing_nor_empty_character}
\alias{assert_is_a_missing_or_empty_string}
\alias{assert_is_a_non_empty_string}
\alias{assert_is_a_non_missing_nor_empty_string}
\alias{assert_is_an_empty_string}
\alias{is_a_missing_or_empty_string}
\alias{is_a_non_empty_string}
\alias{is_a_non_missing_nor_empty_string}
\alias{is_an_empty_string}
\alias{is_empty_character}
\alias{is_missing_or_empty_character}
\alias{is_non_empty_character}
\alias{is_non_missing_nor_empty_character}
\alias{is_not_missing_nor_empty_character}
\title{Does the input contain empty or missing strings?}
\usage{
assert_all_are_empty_character(x, severity = getOption("assertive.severity",
  "stop"))

assert_any_are_empty_character(x, severity = getOption("assertive.severity",
  "stop"))

assert_all_are_non_empty_character(x,
  severity = getOption("assertive.severity", "stop"))

assert_any_are_non_empty_character(x,
  severity = getOption("assertive.severity", "stop"))

assert_all_are_missing_or_empty_character(x,
  severity = getOption("assertive.severity", "stop"))

assert_any_are_missing_or_empty_character(x,
  severity = getOption("assertive.severity", "stop"))

assert_all_are_non_missing_nor_empty_character(x,
  severity = getOption("assertive.severity", "stop"))

assert_any_are_non_missing_nor_empty_character(x,
  severity = getOption("assertive.severity", "stop"))

assert_is_an_empty_string(x, severity = getOption("assertive.severity",
  "stop"))

assert_is_a_non_empty_string(x, severity = getOption("assertive.severity",
  "stop"))

assert_is_a_missing_or_empty_string(x,
  severity = getOption("assertive.severity", "stop"))

assert_is_a_non_missing_nor_empty_string(x,
  severity = getOption("assertive.severity", "stop"))

is_empty_character(x, .xname = get_name_in_parent(x))

is_non_empty_character(x, .xname = get_name_in_parent(x))

is_missing_or_empty_character(x, .xname = get_name_in_parent(x))

is_non_missing_nor_empty_character(x, .xname = get_name_in_parent(x))

is_not_missing_nor_empty_character(x)

is_an_empty_string(x, .xname = get_name_in_parent(x))

is_a_non_empty_string(x, .xname = get_name_in_parent(x))

is_a_missing_or_empty_string(x, .xname = get_name_in_parent(x))

is_a_non_missing_nor_empty_string(x, .xname = get_name_in_parent(x))
}
\arguments{
\item{x}{A character vector.}

\item{severity}{How severe should the consequences of the assertion be?
Either \code{"stop"}, \code{"warning"}, \code{"message"}, or \code{"none"}.}

\item{.xname}{Not intended to be used directly.}
}
\value{
The \code{is_*} functions return logical vectors for strings which
are (non) empty or missing, and the \code{assert_*} functions throw errors
on failure.
}
\description{
Checks for empty or missing strings.
}
\note{
In R, \code{NA_character_} is considered to be a non-empty string
(at least by \code{\link[base]{nzchar}}), which is why many functions are
needed to to clarify the situation.
}
\examples{
# These functions return a vector:
x <- c("", "a", NA)
is_empty_character(x)
is_non_empty_character(x)
is_missing_or_empty_character(x)
is_non_missing_nor_empty_character(x)

# These functions return a single value:
is_an_empty_string("")
is_an_empty_string("a")
is_an_empty_string(NA_character_)

is_a_non_empty_string("")
is_a_non_empty_string("a")
is_a_non_empty_string(NA_character_)

is_a_missing_or_empty_string("")
is_a_missing_or_empty_string("a")
is_a_missing_or_empty_string(NA_character_)

is_a_non_missing_nor_empty_string("")
is_a_non_missing_nor_empty_string("a")
is_a_non_missing_nor_empty_string(NA_character_)
}
\seealso{
\code{\link[assertive.types]{is_character}},
\code{\link[base]{nzchar}}
}

