% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/assert-is-data.R, R/is-data.R
\name{assert_all_are_email_addresses}
\alias{assert_all_are_email_addresses}
\alias{assert_any_are_email_addresses}
\alias{is_email_address}
\title{Does the character vector contain email addresses?}
\usage{
assert_all_are_email_addresses(x, method = c("simple", "rfc5322"),
  na_ignore = FALSE, severity = getOption("assertive.severity",
  "stop"))

assert_any_are_email_addresses(x, method = c("simple", "rfc5322"),
  na_ignore = FALSE, severity = getOption("assertive.severity",
  "stop"))

is_email_address(x, method = c("simple", "rfc5322"))
}
\arguments{
\item{x}{Input to check.}

\item{method}{Name of method to check for validity.  See notes below.}

\item{na_ignore}{A logical value.  If \code{FALSE}, \code{NA} values
cause an error; otherwise they do not.  Like \code{na.rm} in many
stats package functions, except that the position of the failing
values does not change.}

\item{severity}{How severe should the consequences of the assertion be?
Either \code{"stop"}, \code{"warning"}, \code{"message"}, or \code{"none"}.}
}
\value{
A logical vector that is \code{TRUE} when the input contains valid 
email addresses.
}
\description{
Checks that the input contains email addresses.  (It does not check the the 
address exists, merely that the string is in a suitable format.)
}
\note{
Each method specifies a regular expression (see 
\code{\link[base]{regex}}) to match against. The \code{simple} method matches 
most email addresses in use, and is quite good at filtering out typos and 
nonsense.  It won't match \emph{every} email address however.  For example, 
emails from a top level domain longer than 4 characters won't pass.  The 
\code{rfc5322} method implements the official standard for emails.  Thus all 
genuine emails will pass, but since the spec is very broad, it isn't as good 
at filtering out nonsense.
}
\examples{
addresses <- c(
  ok       = "a@b.com", 
  no_at    = "a_at_b.com", 
  no_dot   = "a@bcom", 
  long_tld = "a@b.comma", 
  punct    = "a!$&@b.com", 
  missing  = NA
)
is_email_address(addresses)
is_email_address(addresses, method = "rfc5322")
}
\references{
\url{http://www.regular-expressions.info/email.html} contains the 
regexes used by this function and a good discussion of the pros and cons of 
each.
}
