% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/algebraics.R
\name{algebraic}
\alias{algebraic}
\title{Algebraic relationship}
\usage{
algebraic(definition)
}
\arguments{
\item{definition}{A definition of the model variable}
}
\value{
A building block of type 'algebraic'
}
\description{
This building block defines a model variable as a function of other variables.
}
\details{
Algebraic relationships are equations where one variable is defined as a function of multiple other variables. assemblerr
uses R formulas to implement these equations. For example, the Emax dose response model
\deqn{effect=emax*dose/(ed50 + dose)}
could be declared as\preformatted{    algebraic(effect~emax*dose/(ed50+dose))
}

where the tilde \code{~} replaced the equal sign \code{=} in the definition.
}
\examples{
m <- model() +
  input_variable("dose") +
  prm_log_normal("emax", 10, 0.3) +
  prm_no_var("ed50", 5) +
  algebraic(effect~emax*dose/(ed50+dose)) +
  obs_additive(~effect)
}
