% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/size.R
\name{size}
\alias{size}
\alias{size,itemMatrix-method}
\alias{size,tidLists-method}
\alias{size,itemsets-method}
\alias{size,rules-method}
\title{Number of Items in Sets}
\usage{
size(x, ...)

\S4method{size}{itemMatrix}(x)

\S4method{size}{tidLists}(x)

\S4method{size}{itemsets}(x)

\S4method{size}{rules}(x)
}
\arguments{
\item{x}{an object.}

\item{...}{further (unused) arguments.}
}
\value{
returns a numeric vector of length \code{length(x)}.
Each element is the size of the corresponding element (row in the \link{itemMatrix}) in
object \code{x}. For \link{rules}, \code{size()} returns the sum of the number of
items in the LHS and the RHS.
}
\description{
Provides the generic function \code{size()} and methods to get the size of
each itemset in an \link{itemMatrix} or \link{associations}. For
example, \code{size()} can be used to get a vector with the number of items in each
transaction.
}
\examples{
data("Adult")
summary(size(Adult))

}
\seealso{
Other itemMatrix and transactions functions: 
\code{\link{abbreviate}()},
\code{\link{c}()},
\code{\link{crossTable}()},
\code{\link{duplicated}()},
\code{\link{extract}},
\code{\link{hierarchy}},
\code{\link{image}()},
\code{\link{inspect}()},
\code{\link{is.superset}()},
\code{\link{itemFrequency}()},
\code{\link{itemFrequencyPlot}()},
\code{\link{itemMatrix-class}},
\code{\link{match}()},
\code{\link{merge}()},
\code{\link{random.transactions}()},
\code{\link{sample}()},
\code{\link{sets}},
\code{\link{supportingTransactions}()},
\code{\link{tidLists-class}},
\code{\link{transactions-class}},
\code{\link{unique}()}

Other associations functions: 
\code{\link{abbreviate}()},
\code{\link{associations-class}},
\code{\link{c}()},
\code{\link{duplicated}()},
\code{\link{extract}},
\code{\link{inspect}()},
\code{\link{is.closed}()},
\code{\link{is.generator}()},
\code{\link{is.maximal}()},
\code{\link{is.redundant}()},
\code{\link{is.significant}()},
\code{\link{is.superset}()},
\code{\link{itemsets-class}},
\code{\link{match}()},
\code{\link{rules-class}},
\code{\link{sample}()},
\code{\link{sets}},
\code{\link{sort}()},
\code{\link{unique}()}
}
\author{
Michael Hahsler
}
\concept{associations functions}
\concept{itemMatrix and transactions functions}
\keyword{attribute}
