% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/match.R
\name{match}
\alias{match}
\alias{match,itemMatrix,itemMatrix-method}
\alias{match,rules,rules-method}
\alias{match,itemsets,itemsets-method}
\alias{\%in\%,itemMatrix,itemMatrix-method}
\alias{\%in\%}
\alias{\%in\%,itemMatrix,character-method}
\alias{\%in\%,associations,associations-method}
\alias{\%pin\%,itemMatrix,character-method}
\alias{\%pin\%}
\alias{\%ain\%,itemMatrix,character-method}
\alias{\%ain\%}
\alias{\%oin\%,itemMatrix,character-method}
\alias{\%oin\%}
\title{Value Matching}
\usage{
match(x, table, nomatch = NA_integer_, incomparables = NULL)

\S4method{match}{itemMatrix,itemMatrix}(x, table, nomatch = NA_integer_, incomparables = NULL)

\S4method{match}{rules,rules}(x, table, nomatch = NA_integer_, incomparables = NULL)

\S4method{match}{itemsets,itemsets}(x, table, nomatch = NA_integer_, incomparables = NULL)

\S4method{\%in\%}{itemMatrix,itemMatrix}(x, table)

\S4method{\%in\%}{itemMatrix,character}(x, table)

\S4method{\%in\%}{associations,associations}(x, table)

\S4method{\%pin\%}{itemMatrix,character}(x, table)

\S4method{\%ain\%}{itemMatrix,character}(x, table)

\S4method{\%oin\%}{itemMatrix,character}(x, table)
}
\arguments{
\item{x}{an object of class \link{itemMatrix}, \link{transactions} or
\link{associations}.}

\item{table}{a set of associations or transactions to be matched against.}

\item{nomatch}{the value to be returned in the case when no match is found.}

\item{incomparables}{not implemented.}
}
\value{
\code{match}: An integer vector of the same length as \code{x}
giving the position in \code{table} of the first match if there is a match,
otherwise \code{nomatch}.

\code{\%in\%}, \verb{\%pin\%}, \verb{\%ain\%}, \verb{\%oin\%}: A logical vector,
indicating if a match was located for each element of \code{x}.
}
\description{
Provides the generic function \code{match()} and the methods for
\link{associations}, \link{transactions} and \link{itemMatrix} objects.  \code{match()} returns a vector
of the positions of (first) matches of its first argument in its second.
}
\details{
\code{\%in\%} is a more intuitive interface as a binary operator, which
returns a logical vector indicating if there is a match or not for the items
in the itemsets (left operand) with the items in the table (right operand).

\pkg{arules} defines additional binary operators for matching itemsets:
\verb{\%pin\%} uses \emph{partial matching} on the table; \verb{\%ain\%}
itemsets have to match/include \emph{all} items in the table; \verb{\%oin\%}
itemsets can \emph{only} match/include the items in the table.  The binary
matching operators or often used in \code{\link[=subset]{subset()}}.
}
\examples{
data("Adult")

## get unique transactions, count frequency of unique transactions
## and plot frequency of unique transactions
vals <- unique(Adult)
cnts <- tabulate(match(Adult, vals))
plot(sort(cnts, decreasing=TRUE))

## find all transactions which are equal to transaction 10 in Adult
which(Adult \%in\% Adult[10])

## for transactions we can also match directly with itemLabels.
## Find in the first 10 transactions the ones which
## contain age=Middle-aged (see help page for class itemMatrix)
Adult[1:10] \%in\% "age=Middle-aged"

## find all transactions which contain items that partially match "age=" (all here).
Adult[1:10] \%pin\% "age="

## find all transactions that only include the item "age=Middle-aged" (none here).
Adult[1:10] \%oin\% "age=Middle-aged"

## find al transaction which contain both items "age=Middle-aged" and "sex=Male"
Adult[1:10] \%ain\% c("age=Middle-aged", "sex=Male")
}
\seealso{
Other associations functions: 
\code{\link{abbreviate}()},
\code{\link{associations-class}},
\code{\link{c}()},
\code{\link{duplicated}()},
\code{\link{extract}},
\code{\link{inspect}()},
\code{\link{is.closed}()},
\code{\link{is.generator}()},
\code{\link{is.maximal}()},
\code{\link{is.redundant}()},
\code{\link{is.significant}()},
\code{\link{is.superset}()},
\code{\link{itemsets-class}},
\code{\link{rules-class}},
\code{\link{sample}()},
\code{\link{sets}},
\code{\link{size}()},
\code{\link{sort}()},
\code{\link{unique}()}

Other itemMatrix and transactions functions: 
\code{\link{abbreviate}()},
\code{\link{crossTable}()},
\code{\link{c}()},
\code{\link{duplicated}()},
\code{\link{extract}},
\code{\link{hierarchy}},
\code{\link{image}()},
\code{\link{inspect}()},
\code{\link{is.superset}()},
\code{\link{itemFrequencyPlot}()},
\code{\link{itemFrequency}()},
\code{\link{itemMatrix-class}},
\code{\link{merge}()},
\code{\link{random.transactions}()},
\code{\link{sample}()},
\code{\link{sets}},
\code{\link{size}()},
\code{\link{supportingTransactions}()},
\code{\link{tidLists-class}},
\code{\link{transactions-class}},
\code{\link{unique}()}
}
\author{
Michael Hahsler
}
\concept{associations functions}
\concept{itemMatrix and transactions functions}
\keyword{manip}
