% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/itemMatrix.R
\docType{class}
\name{itemMatrix-class}
\alias{itemMatrix-class}
\alias{itemMatrix}
\alias{initialize,itemMatrix-method}
\alias{show,itemMatrix-method}
\alias{summary,itemMatrix-method}
\alias{summary.itemMatrix-class}
\alias{show,summary.itemMatrix-method}
\alias{dim,itemMatrix-method}
\alias{nitems}
\alias{nitems,itemMatrix-method}
\alias{length,itemMatrix-method}
\alias{toLongFormat}
\alias{toLongFormat,itemMatrix-method}
\alias{labels,itemMatrix-method}
\alias{itemLabels}
\alias{itemLabels<-}
\alias{itemLabels,itemMatrix-method}
\alias{itemLabels<-,itemMatrix-method}
\alias{itemInfo}
\alias{itemInfo<-}
\alias{itemInfo,itemMatrix-method}
\alias{itemInfo<-,itemMatrix-method}
\alias{itemsetInfo}
\alias{itemsetInfo<-}
\alias{itemsetInfo,itemMatrix-method}
\alias{itemsetInfo<-,itemMatrix-method}
\alias{coercion-itemMatrix}
\alias{coerce,matrix,itemMatrix-method}
\alias{coerce,itemMatrix,matrix-method}
\alias{coerce,list,itemMatrix-method}
\alias{coerce,itemMatrix,list-method}
\alias{coerce,itemMatrix,ngCMatrix-method}
\alias{coerce,ngCMatrix,itemMatrix-method}
\alias{dimnames,itemMatrix-method}
\alias{dimnames<-,itemMatrix,list-method}
\title{Class itemMatrix --- Sparse Binary Incidence Matrix to Represent Sets of
Items}
\usage{
\S4method{summary}{itemMatrix}(object, maxsum = 6, ...)

\S4method{dim}{itemMatrix}(x)

nitems(x, ...)

\S4method{nitems}{itemMatrix}(x)

\S4method{length}{itemMatrix}(x)

toLongFormat(from, ...)

\S4method{toLongFormat}{itemMatrix}(from, cols = c("ID", "item"), decode = TRUE)

\S4method{labels}{itemMatrix}(object, itemSep = ",", setStart = "{", setEnd = "}")

itemLabels(object, ...)

itemLabels(object) <- value

\S4method{itemLabels}{itemMatrix}(object)

\S4method{itemLabels}{itemMatrix}(object) <- value

itemInfo(object)

itemInfo(object) <- value

\S4method{itemInfo}{itemMatrix}(object)

\S4method{itemInfo}{itemMatrix}(object) <- value

itemsetInfo(object)

itemsetInfo(object) <- value

\S4method{itemsetInfo}{itemMatrix}(object)

\S4method{itemsetInfo}{itemMatrix}(object) <- value

\S4method{dimnames}{itemMatrix}(x)

\S4method{dimnames}{itemMatrix,list}(x) <- value
}
\arguments{
\item{object, x, from}{the object.}

\item{maxsum}{integer, how many items should be shown for the summary?}

\item{...}{further parameters}

\item{cols}{columns for the long format.}

\item{decode}{decode item IDs to item labels.}

\item{itemSep}{item separator symbol.}

\item{setStart}{set start symbol.}

\item{setEnd}{set end symbol.}

\item{value}{replacement value}
}
\description{
The \code{itemMatrix} class is the basic building block for \link{transactions},
and \link{associations}.  The class contains a sparse
Matrix representation of a set of itemsets and the
corresponding item labels.
}
\details{
Sets of itemsets are represented as a compressed sparse
binary matrix. Columns represent items and rows are the set/transactions. In
the compressed form, each itemset is a vector of column indices (called item
IDs) representing the items.

\strong{Note:} If you work with several \code{itemMatrix} objects at the same time (e.g.,
several transaction sets, lhs and rhs of a rule, etc.), then the encoding
(itemLabes and order of the items in the binary matrix) in the different
itemMatrices is important and needs to conform. See \link{itemCoding}
to learn how to encode and recode \code{itemMatrix} objects.
}
\section{Functions}{
\itemize{
\item \code{summary,itemMatrix-method}: show a summary.

\item \code{dim,itemMatrix-method}: returns the number of rows
(itemsets) and columns (items in the encoding).

\item \code{nitems,itemMatrix-method}: returns the number of items in the encoding.

\item \code{length,itemMatrix-method}: returns the number of itemsets (rows) in the matrix.

\item \code{toLongFormat,itemMatrix-method}: convert the sets to long format
(a data.frame with two columns, ID and item). Column names
can be specified as a character vector of length 2 called \code{cols}.

\item \code{labels,itemMatrix-method}: returns labels for the itemsets.
The following arguments can be used to customize the representation
of the labels: \code{itemSep}, \code{setStart} and \code{setEnd}.

\item \code{itemLabels,itemMatrix-method}: returns the item labels used for encoding as a character vector.

\item \code{itemLabels<-,itemMatrix-method}: replaces the item labels used for encoding.

\item \code{itemInfo,itemMatrix-method}: returns the whole item/column information data.frame including labels.

\item \code{itemInfo<-,itemMatrix-method}: replaces the item/column info by a data.frame.

\item \code{itemsetInfo,itemMatrix-method}: returns the item set/row information data.frame.

\item \code{itemsetInfo<-,itemMatrix-method}: replaces the item set/row info by a data.frame.

\item \code{dimnames,itemMatrix-method}: returns a list with the dimname vectors.

\item \code{dimnames<-,itemMatrix,list-method}: replace the dimnames.
}}

\section{Slots}{

\describe{
\item{\code{data}}{a sparse matrix of class \linkS4class{ngCMatrix} representing the itemsets. \strong{Note: the matrix is stored for efficiency reasons transposed!}.}

\item{\code{itemInfo}}{a data.frame}

\item{\code{itemsetInfo}}{a data.frame}
}}

\section{Objects from the Class}{

Objects can be created by calls of the form
\code{new("itemMatrix", ...)}.  However, most of the time objects will be
created by coercion from a matrix, list or data.frame.
}

\section{Coercion}{

\itemize{
\item as("matrix", "itemMatrix")
\item as("itemMatrix", "matrix")
\item as("list", "itemMatrix")
\item as("itemMatrix", "list")
\item as("itemMatrix", "ngCMatrix")
\item as("ngCMatrix", "itemMatrix")
}
}

\examples{
set.seed(1234)

## Generate a logical matrix with 5000 random itemsets for 20 items
m <- matrix(runif(5000 * 20) > 0.8, ncol = 20,
            dimnames = list(NULL, paste("item", c(1:20), sep = "")))
head(m)

## Coerce the logical matrix into an itemMatrix object
imatrix <- as(m, "itemMatrix")
imatrix

## An itemMatrix contains a set of itemsets (each row is an itemset).
## The length of the set is the number of rows.
length(imatrix)

## The sparese matrix also has regular matrix  dimensions.
dim(imatrix)
nrow(imatrix)
ncol(imatrix)

## Subsetting: Get first 5 elements (rows) of the itemMatrix. This can be done in
## several ways.
imatrix[1:5]            ### get elements 1:5
imatrix[1:5, ]          ### Matrix subsetting for rows 1:5
head(imatrix, n = 5)    ### head()

## Get first 5 elements (rows) of the itemMatrix as list.
as(imatrix[1:5], "list")

## Get first 5 elements (rows) of the itemMatrix as matrix.
as(imatrix[1:5], "matrix")

## Get first 5 elements (rows) of the itemMatrix as sparse ngCMatrix.
## Warning: For efficiency reasons, the ngCMatrix is transposed!
as(imatrix[1:5], "ngCMatrix")

## Get labels for the first 5 itemsets (first default and then with
## custom formating)
labels(imatrix[1:5])
labels(imatrix[1:5], itemSep = " + ", setStart = "", setEnd = "")

## Create itemsets manually from an itemMatrix. Itemsets contain items in the form of
## an itemMatrix and additional quality measures (not supplied in the example).
is <- new("itemsets", items = imatrix)
is
inspect(head(is, n = 3))


## Create rules manually. I use imatrix[4:6] for the lhs of the rules and
## imatrix[1:3] for the rhs. Rhs and lhs cannot share items so I use
## itemSetdiff here. I also assign missing values for the quality measures support
## and confidence.
rules <- new("rules",
             lhs = itemSetdiff(imatrix[4:6], imatrix[1:3]),
             rhs = imatrix[1:3],
             quality = data.frame(support = c(NA, NA, NA),
                                  confidence =  c(NA, NA, NA)
          ))
rules
inspect(rules)

## Manually create a itemMatrix with an item encoding that matches imatrix (20 items in order
## item1, item2, ..., item20)
itemset_list <- list(c("item1","item2"),
                     c("item3"))

imatrix_new <- encode(itemset_list, itemLabels = imatrix)
imatrix_new
compatible(imatrix_new, imatrix)

}
\seealso{
Other itemMatrix and transactions functions: 
\code{\link{abbreviate}()},
\code{\link{crossTable}()},
\code{\link{c}()},
\code{\link{duplicated}()},
\code{\link{extract}},
\code{\link{hierarchy}},
\code{\link{image}()},
\code{\link{inspect}()},
\code{\link{is.superset}()},
\code{\link{itemFrequencyPlot}()},
\code{\link{itemFrequency}()},
\code{\link{match}()},
\code{\link{merge}()},
\code{\link{random.transactions}()},
\code{\link{sample}()},
\code{\link{sets}},
\code{\link{size}()},
\code{\link{supportingTransactions}()},
\code{\link{tidLists-class}},
\code{\link{transactions-class}},
\code{\link{unique}()}
}
\author{
Michael Hahsler
}
\concept{itemMatrix and transactions functions}
\keyword{classes}
