% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/freqlist.R
\name{freqlist}
\alias{freqlist}
\alias{freqlist.table}
\alias{freqlist.formula}
\title{freqlist}
\usage{
freqlist(object, ...)

\method{freqlist}{table}(object, na.options = c("include", "showexclude",
  "remove"), strata = NULL, labelTranslations = NULL, control = NULL,
  ...)

\method{freqlist}{formula}(formula, data, subset, na.action,
  strata = NULL, labelTranslations = NULL, control = NULL, addNA,
  exclude, drop.unused.levels, ...)
}
\arguments{
\item{object}{An R object, usually of class \code{"table"} or class \code{"xtabs"}}

\item{...}{additional arguments. In the formula method, these are passed to the table method. These are also passed to
\code{\link{freq.control}}}

\item{na.options}{a character string indicating how to handling missing values: \code{"include"}
(include values with NAs in counts and percentages),
\code{"showexclude"} (show NAs but exclude from cumulative counts and all percentages),
\code{"remove"} (remove values with NAs); default is \code{"include"}.}

\item{strata}{(formerly \code{groupBy}) an optional character string specifying a variable(s) to use for grouping when calculating cumulative
counts and percentages. \code{\link{summary.freqlist}} will also separate by grouping variable for printing. Note that this is different
from \code{modelsum} and \code{tableby}, which take bare column names (and only one, at that!)}

\item{labelTranslations}{an optional character string (or list) of labels to use for variable levels when summarizing.
Names will be matched appropriately.}

\item{control}{control parameters to handle optional settings within \code{freqlist}. See \code{\link{freq.control}}}

\item{formula, data, subset, na.action, addNA, exclude, drop.unused.levels}{Arguments passed to \code{\link[stats]{xtabs}}. Note
that \code{addNA=} only works in R >= 3.4.0.}
}
\value{
An object of class \code{c("freqlist", "arsenal_table")}
}
\description{
Approximate the output from SAS's \code{PROC FREQ} procedure when using the \code{/list} option of the \code{TABLE} statement.
}
\examples{
# load mockstudy data
data(mockstudy)
tab.ex <- table(mockstudy[c("arm", "sex", "mdquality.s")], useNA = "ifany")
noby <- freqlist(tab.ex, na.options = "include")
summary(noby)
withby <- freqlist(tab.ex, strata = c("arm","sex"), na.options = "showexclude")
summary(withby)
}
\seealso{
\code{\link{arsenal_table}}, \code{\link{summary.freqlist}}, \code{\link{freq.control}},
  \code{\link[base]{table}}, \code{\link[stats]{xtabs}}, \code{\link[knitr]{kable}}
}
\author{
Tina Gunderson, with revisions by Ethan Heinzen
}
