% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/summary.compare.R
\name{summary.compare}
\alias{summary.compare}
\alias{summary.compare.data.frame}
\alias{print.summary.compare.data.frame}
\title{The summary method for a \code{compare.data.frame} object}
\usage{
\method{summary}{compare.data.frame}(object, ..., show.attrs = FALSE,
  max.print.vars = NA, max.print.obs = NA, max.print.diff = 10,
  max.print.attrs = NA)

\method{print}{summary.compare.data.frame}(x, ..., format = "pandoc")
}
\arguments{
\item{object}{An object of class \code{"compare.data.frame"}, as made by the \code{\link{compare.data.frame}} S3 method.}

\item{...}{Other arguments. In \code{print}, these are passed to \code{\link[knitr]{kable}}.}

\item{show.attrs}{Logical, denoting whether to show the actual attributes which are different. For (e.g.) factors with lots
of levels, this can make the tables quite wide, so this feature is \code{FALSE} by default.}

\item{max.print.vars, max.print.obs, max.print.diff, max.print.attrs}{Integers denoting the maximum number of differences to report
for each of the three tables. Passing \code{NA} will print all differences.}

\item{x}{An object returned by the \code{summary.compare.data.frame} function.}

\item{format}{Passed to \code{\link[knitr]{kable}}: the format for the table. The default here is "pandoc".
To use the default in \code{kable}, pass \code{NULL}.}
}
\value{
An object of class \code{"summary.compare.data.frame"} is returned.
}
\description{
Print a more detailed output of the \code{\link{compare.data.frame}} object.
}
\seealso{
compare.data.frame
}
