% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/filesystem.R
\docType{class}
\name{FileSystem}
\alias{FileSystem}
\alias{LocalFileSystem}
\alias{SubTreeFileSystem}
\title{FileSystem classes}
\description{
\code{FileSystem} is an abstract file system API,
\code{LocalFileSystem} is an implementation accessing files
on the local machine. \code{SubTreeFileSystem} is an implementation that delegates
to another implementation after prepending a fixed base path
}
\section{Factory}{


The \verb{$create()} factory methods instantiate the \code{FileSystem} object and
take the following arguments, depending on the subclass:
\itemize{
\item no argument is needed for instantiating a \code{LocalFileSystem}
\item \code{base_path} and \code{base_fs} for instantiating a \code{SubTreeFileSystem}
}
}

\section{Methods}{

\itemize{
\item \verb{$GetTargetStats(x)}: \code{x} may be a \link{FileSelector} or a character
vector of paths. Returns a list of \link{FileStats}
\item \verb{$CreateDir(path, recursive = TRUE)}: Create a directory and subdirectories.
\item \verb{$DeleteDir(path)}: Delete a directory and its contents, recursively.
\item \verb{$DeleteDirContents(path)}: Delete a directory's contents, recursively.
Like \verb{$DeleteDir()},
but doesn't delete the directory itself. Passing an empty path (\code{""}) will
wipe the entire filesystem tree.
\item \verb{$DeleteFile(path)} : Delete a file.
\item \verb{$DeleteFiles(paths)} : Delete many files. The default implementation
issues individual delete operations in sequence.
\item \verb{$Move(src, dest)}: Move / rename a file or directory. If the destination
exists:
if it is a non-empty directory, an error is returned
otherwise, if it has the same type as the source, it is replaced
otherwise, behavior is unspecified (implementation-dependent).
\item \verb{$CopyFile(src, dest)}: Copy a file. If the destination exists and is a
directory, an error is returned. Otherwise, it is replaced.
\item \verb{$OpenInputStream(path)}: Open an \link[=InputStream]{input stream} for
sequential reading.
\item \verb{$OpenInputFile(path)}: Open an \link[=RandomAccessFile]{input file} for random
access reading.
\item \verb{$OpenOutputStream(path)}: Open an \link[=OutputStream]{output stream} for
sequential writing.
\item \verb{$OpenAppendStream(path)}: Open an \link[=OutputStream]{output stream} for
appending.
}
}

