% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/parquet.R
\name{read_parquet}
\alias{read_parquet}
\title{Read a Parquet file}
\usage{
read_parquet(file, col_select = NULL, as_tibble = TRUE,
  props = parquet_arrow_reader_properties(), ...)
}
\arguments{
\item{file}{A character path to a local file, or an Arrow input stream}

\item{col_select}{A \link[tidyselect:vars_select]{tidy selection specification}
of columns, as used in \code{dplyr::select()}.}

\item{as_tibble}{Should the function return a \code{data.frame} or an
\link[=arrow__Table]{arrow::Table}?}

\item{props}{reader file properties, as created by \code{\link[=parquet_arrow_reader_properties]{parquet_arrow_reader_properties()}}}

\item{...}{additional parameters}
}
\value{
A \link[=arrow__Table]{arrow::Table}, or a \code{data.frame} if \code{as_tibble} is
\code{TRUE}.
}
\description{
'\href{https://parquet.apache.org/}{Parquet}' is a columnar storage file format.
This function enables you to read Parquet files into R.
}
\examples{
\donttest{
try({
  df <- read_parquet(system.file("v0.7.1.parquet", package="arrow"))
})
}
}
