context("Multiset Combinations")

test_that("Multiset Combinations - ncombinations", {
    expect_equal(ncombinations(freq = c(2, 3, 3, 4), k = 4), 29)
    expect_equal(ncombinations(x = LETTERS[1:4], freq = c(2, 3, 3, 4), k = 4), 29)
    expect_error(ncombinations(freq = rep(10, 11), k = 50), "integer overflow")
    expect_error(ncombinations(x = LETTERS[1:11], freq = rep(10, 11), k = 50), "integer overflow")
    expect_equal(ncombinations(freq = rep(10, 11), k = 50, bigz = TRUE), gmp::as.bigz("9608991865"))
    expect_equal(ncombinations(freq = c(0, 0, 0), k = 4), 0)
    expect_equal(ncombinations(freq = c(0, 0, 0), k = 0), 1)
    expect_error(ncombinations(freq = c(2, 3, 3, 4), k = -1), "expect non-negative integer")
    expect_error(ncombinations(freq = c(2, 3, 3, 4), k = 1.5), "expect non-negative integer")
})

test_that("Multiset Combinations - combinations", {
    comb <- combinations(freq = c(2, 3, 3, 4), k = 4)
    expect_equal(nrow(comb), 29)
    expect_equal(ncol(comb), 4)
    expect_equal(comb[1, ], c(1, 1, 2, 2))
    expect_equal(comb[29, ], rep(4, 4))

    comb <- combinations(freq = c(2, 3, 3, 4), k = 4, type = "r")
    expect_equal(nrow(comb), 29)
    expect_equal(ncol(comb), 4)
    expect_equal(comb[1, ], c(1, 1, 2, 2))
    expect_equal(comb[29, ], rep(4, 4))

    comb <- combinations(freq = c(2, 3, 3, 4), k = 4, type = "c")
    expect_equal(ncol(comb), 29)
    expect_equal(nrow(comb), 4)
    expect_equal(comb[, 1], c(1, 1, 2, 2))
    expect_equal(comb[, 29], rep(4, 4))

    comb <- combinations(freq = c(2, 3, 3, 4), k = 4, type = "l")
    expect_equal(length(comb), 29)
    expect_equal(comb[[1]], c(1, 1, 2, 2))
    expect_equal(comb[[29]], rep(4, 4))

    comb <- combinations(x = LETTERS[1:4], freq = c(2, 3, 3, 4), k = 4)
    expect_equal(nrow(comb), 29)
    expect_equal(ncol(comb), 4)
    expect_equal(comb[1, ], LETTERS[c(1, 1, 2, 2)])
    expect_equal(comb[29, ], LETTERS[rep(4, 4)])

    expect_error(combinations(freq = rep(10, 11), k = 50), "too many results")
    expect_error(combinations(freq = c(2, 3, 3, 4), k = -1), "expect non-negative integer")
    expect_error(combinations(freq = c(2, 3, 3, 4), k = 1.5), "expect non-negative integer")
    expect_equal(dim(combinations(freq = c(2, 3, 3, 4), k = 0)), c(1, 0))
    expect_equal(dim(combinations(freq = c(0, 0, 0), k = 1 )), c(0, 1))
    expect_equal(dim(combinations(freq = c(0, 0, 0), k = 0 )), c(1, 0))
})

test_that("Multiset Combinations - icombinations", {
    icomb <- icombinations(freq = c(2, 3, 3, 4), k = 4)
    comb <- combinations(freq = c(2, 3, 3, 4), k = 4)
    expect_equal(icomb$collect(), comb)
    expect_equal(icomb$getnext(), c(1, 1, 2, 2))
    expect_equal(icomb$getnext(), c(1, 1, 2, 3))
    icomb$getnext(20)
    expect_equal(nrow(icomb$getnext(10)), 7)
    expect_equal(icomb$getnext(), NULL)

    comb <- combinations(freq = c(2, 3, 3, 4), k = 4, type = "r")
    expect_equal(icomb$collect(type = "r"), comb)
    expect_equal(icomb$getnext(type = "r"), t(c(1, 1, 2, 2)))
    expect_equal(icomb$getnext(type = "r"), t(c(1, 1, 2, 3)))
    icomb$getnext(20, type = "r")
    expect_equal(nrow(icomb$getnext(10, type = "r")), 7)
    expect_equal(icomb$getnext(type = "r"), NULL)

    comb <- combinations(freq = c(2, 3, 3, 4), k = 4, type = "c")
    expect_equal(icomb$collect(type = "c"), comb)
    expect_equal(icomb$getnext(type = "c"), t(t(c(1, 1, 2, 2))))
    expect_equal(icomb$getnext(type = "c"), t(t(c(1, 1, 2, 3))))
    icomb$getnext(20, type = "c")
    expect_equal(ncol(icomb$getnext(10, type = "c")), 7)
    expect_equal(icomb$getnext(type = "c"), NULL)

    comb <- combinations(freq = c(2, 3, 3, 4), k = 4, type = "l")
    expect_equal(icomb$collect(type = "l"), comb)
    expect_equal(icomb$getnext(type = "l"), list(c(1, 1, 2, 2)))
    expect_equal(icomb$getnext(type = "l"), list(c(1, 1, 2, 3)))
    icomb$getnext(20, type = "l")
    expect_equal(length(icomb$getnext(10, type = "l")), 7)
    expect_equal(icomb$getnext(type = "l"), NULL)

    expect_error(icombinations(freq = c(2, 3, 3, 4), k = -1), "expect non-negative integer")
    expect_error(icombinations(freq = c(2, 3, 3, 4), k = 1.5), "expect non-negative integer")
    icomb <- icombinations(freq = c(2, 3, 3, 4), k = 0)
    expect_equal(dim(icomb$collect()), c(1, 0))
    expect_equal(length(icomb$getnext()), 0)
    expect_equal(icomb$getnext(), NULL)
    icomb <- icombinations(freq = c(2, 3, 3, 4), k = 13)
    expect_equal(icomb$collect(), NULL)
    expect_equal(icomb$getnext(), NULL)
})
